/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.model.converters;

import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BvFieldNameConverter
extends ResolvingConverter<PsiField>
implements CustomReferenceConverter<PsiField> {
    @NotNull
    public Collection<? extends PsiField> getVariants(ConvertContext context) {
        PsiClass psiClass = BVUtils.getBeanClass(context);
        List<Object> list = psiClass == null ? Collections.emptyList() : Arrays.asList(psiClass.getFields());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/BvFieldNameConverter", "getVariants"));
        }
        return list;
    }

    public PsiField fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        for (PsiField psiField : this.getVariants(context)) {
            if (!s.equals(psiField.getName())) continue;
            return psiField;
        }
        return null;
    }

    public String toString(@Nullable PsiField psiField, ConvertContext context) {
        return psiField == null ? null : psiField.getName();
    }

    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<PsiField> domValue, PsiElement element, final ConvertContext context) {
        PsiReferenceBase<PsiElement> ref = new PsiReferenceBase<PsiElement>(element, true){

            public PsiElement resolve() {
                return (PsiElement)domValue.getValue();
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = BvFieldNameConverter.this.getVariants(context).toArray();
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/BvFieldNameConverter$1", "getVariants"));
                }
                return objectArray;
            }

            public boolean isReferenceTo(PsiElement element) {
                return super.isReferenceTo(element);
            }
        };
        PsiReference[] psiReferenceArray = new PsiReference[]{ref};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/BvFieldNameConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

