/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.toolWindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.SortedList;
import java.awt.event.InputEvent;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBVNode
extends SimpleNode {
    public AbstractBVNode(SimpleNode parent) {
        super(parent);
    }

    @Nullable
    public PsiElement getPsiElement() {
        return null;
    }

    @Nullable
    public Navigatable getNavigatableElement() {
        PsiElement element = this.getPsiElement();
        return element instanceof Navigatable ? (Navigatable)element : null;
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        Navigatable navigatable = this.getNavigatableElement();
        if (navigatable != null) {
            navigatable.navigate(true);
        }
    }

    protected static Collection<PsiMemberSimpleNode> createSortedList() {
        return new SortedList((Comparator)new Comparator<PsiMemberSimpleNode>(){

            @Override
            public int compare(PsiMemberSimpleNode node, PsiMemberSimpleNode node2) {
                Object member = node.getMember();
                Object member2 = node2.getMember();
                if (member != null && member.isValid() && member2 != null && member2.isValid()) {
                    boolean inLib2;
                    boolean inLib = BVUtils.isInLibrary(member);
                    if (inLib != (inLib2 = BVUtils.isInLibrary(member2))) {
                        return inLib ? 1 : -1;
                    }
                    String name = member.getName();
                    String name1 = member2.getName();
                    if (name != null && name1 != null) {
                        return name.compareTo(name1);
                    }
                }
                return 0;
            }
        });
    }

    public SimpleNode[] getChildren() {
        return NO_CHILDREN;
    }
}

