/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.utils;

import com.intellij.beanValidation.model.xml.Bean;
import com.intellij.beanValidation.model.xml.BvField;
import com.intellij.beanValidation.model.xml.BvGetter;
import com.intellij.beanValidation.model.xml.Constraint;
import com.intellij.beanValidation.model.xml.Element;
import com.intellij.beanValidation.model.xml.ValidationConfig;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BVUtils {
    private static final Key<CachedValue<Collection<PsiClass>>> MODULE_SCOPE_CONSTRAINT_ANNOTATIONS = new Key("MODULE_SCOPE_CONSTRAINT_ANNOTATIONS");

    private BVUtils() {
    }

    @NotNull
    public static Collection<PsiClass> getConstraintClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/beanValidation/utils/BVUtils", "getConstraintClasses"));
        }
        Collection collection = JamCommonUtil.getAnnotatedTypes((Module)module, MODULE_SCOPE_CONSTRAINT_ANNOTATIONS, (String)"javax.validation.Constraint");
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/utils/BVUtils", "getConstraintClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getQualifiedNames(Iterable<PsiClass> annotations) {
        List list = ContainerUtil.mapNotNull(annotations, (Function)new Function<PsiClass, String>(){

            public String fun(PsiClass psiClass) {
                return psiClass.getQualifiedName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/utils/BVUtils", "getQualifiedNames"));
        }
        return list;
    }

    public static boolean isBeanValidationDefined(Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.validation.Constraint", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    public static boolean isInLibrary(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex().isInLibraryClasses(virtualFile);
    }

    public static Collection<PsiClass> getConstraintValidators(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/beanValidation/utils/BVUtils", "getConstraintValidators"));
        }
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.validation.ConstraintValidator", searchScope);
        if (psiClass == null) {
            return Collections.emptyList();
        }
        Query query = ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)searchScope, (boolean)true, (boolean)true, (boolean)false);
        return query.findAll();
    }

    @Nullable
    public static PsiClass getBeanClass(ConvertContext context) {
        Bean bean = (Bean)context.getInvocationElement().getParentOfType(Bean.class, true);
        return bean == null ? null : (PsiClass)bean.getClassAttr().getValue();
    }

    @Nullable
    public static PsiMember getMember(ConvertContext context) {
        BvField field = (BvField)context.getInvocationElement().getParentOfType(BvField.class, true);
        if (field != null) {
            return (PsiMember)field.getName().getValue();
        }
        BvGetter getter = (BvGetter)context.getInvocationElement().getParentOfType(BvGetter.class, true);
        if (getter != null) {
            return (PsiMember)getter.getName().getValue();
        }
        return null;
    }

    @Nullable
    public static PsiClass getConstraint(ConvertContext context) {
        Constraint constraint = (Constraint)context.getInvocationElement().getParentOfType(Constraint.class, true);
        return constraint == null ? null : (PsiClass)constraint.getAnnotation().getValue();
    }

    @Nullable
    public static PsiMethod getAnnotationMethod(ConvertContext context) {
        Element element = (Element)context.getInvocationElement().getParentOfType(Element.class, false);
        return element == null ? null : (PsiMethod)element.getName().getValue();
    }

    @Nullable
    public static XmlFile getValidationXml(Module module) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            PsiFile file;
            VirtualFile config;
            VirtualFile metaInf = root.findChild("META-INF");
            if (metaInf == null || (config = metaInf.findChild("validation.xml")) == null || !((file = PsiManager.getInstance((Project)module.getProject()).findFile(config)) instanceof XmlFile)) continue;
            return (XmlFile)file;
        }
        return null;
    }

    public static XmlFile[] getConstraintFiles(Module module) {
        DomFileElement domFileElement;
        XmlFile config = BVUtils.getValidationXml(module);
        if (config != null && (domFileElement = DomManager.getDomManager((Project)module.getProject()).getFileElement(config, ValidationConfig.class)) != null) {
            ValidationConfig root = (ValidationConfig)domFileElement.getRootElement();
            ArrayList<XmlFile> files = new ArrayList<XmlFile>();
            for (GenericDomValue<XmlFile> domValue : root.getConstraintMappings()) {
                XmlFile file = (XmlFile)domValue.getValue();
                if (file == null) continue;
                files.add(file);
            }
            return files.toArray(new XmlFile[files.size()]);
        }
        return XmlFile.EMPTY_ARRAY;
    }
}

