/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.Checkin;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.CCaseViewsManager;
import net.sourceforge.transparent.ClearCase;
import net.sourceforge.transparent.Status;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCaseCheckinEnvironment
implements CheckinEnvironment {
    @NonNls
    private static final String CHECKIN_TITLE = "Check In";
    @NonNls
    private static final String SCR_TITLE = "SCR Number";
    @NonNls
    private static final String CHECKOUT_FOLDER = "Checking out folder: ";
    @NonNls
    private static final String ADDING_FILES = "Adding file: ";
    @NonNls
    private static final String CHECKIN_FOLDER = "Checking in folder: ";
    @NonNls
    private static final String CHANGE_ACTIVITY = "Changing activity for file: ";
    private final Project project;
    private final TransparentVcs host;
    private double fraction;
    private String submittedChangeListName;

    public CCaseCheckinEnvironment(Project project, TransparentVcs host) {
        this.project = project;
        this.host = host;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        final JPanel additionalPanel = new JPanel();
        final JTextField scrNumber = new JTextField();
        additionalPanel.setLayout(new BorderLayout());
        additionalPanel.add((Component)new Label(SCR_TITLE), "North");
        additionalPanel.add((Component)scrNumber, "Center");
        scrNumber.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                scrNumber.selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusevent) {
            }
        });
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                return additionalPanel;
            }

            public void saveState() {
            }

            public void restoreState() {
                this.refresh();
            }

            public void refresh() {
            }
        };
    }

    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        ClearCase cc = this.host.getClearCase();
        HashSet<String> commentsPerFile = new HashSet<String>();
        for (FilePath path : filesToCheckin) {
            String fileComment;
            FileStatus status;
            VirtualFile vfile = path.getVirtualFile();
            if (vfile == null || (status = FileStatusManager.getInstance((Project)this.project).getStatus(vfile)) == FileStatus.ADDED || !StringUtil.isNotEmpty((String)(fileComment = cc.getCheckoutComment(new File(path.getPresentableUrl()))))) continue;
            commentsPerFile.add(fileComment);
        }
        StringBuilder overallComment = new StringBuilder();
        for (String comment : commentsPerFile) {
            overallComment.append(comment).append("\n-----");
        }
        return overallComment.length() > 0 ? overallComment.toString() : null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return CHECKIN_TITLE;
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return true;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    public List<VcsException> commit(List<Change> changes, String comment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (parametersHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "net/sourceforge/transparent/Checkin/CCaseCheckinEnvironment", "commit"));
        }
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        HashSet<FilePath> processedFiles = new HashSet<FilePath>();
        if (!SystemInfo.isWindows) {
            comment = comment.replace("\"", "\\\"");
        }
        CCaseCheckinEnvironment.clearTemporaryStatuses(changes);
        this.storeChangeListName(changes);
        this.adjustChangesWithRenamedParentFolders(changes);
        try {
            this.initProgress(changes.size());
            this.commitRenamedFolders(changes, comment, errors);
            this.commitDeleted(changes, comment, errors);
            this.commitChanged(changes, comment, processedFiles, errors);
            this.commitNew(changes, comment, processedFiles, errors);
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        this.checkForUnchangedFolders(changes, errors, comment);
        VcsUtil.refreshFiles((Project)this.project, processedFiles);
        return errors;
    }

    private void checkForUnchangedFolders(List<Change> changes, List<VcsException> errors, String comment) {
        for (Change change : changes) {
            Status status;
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            File ioFile = filePath.getIOFile();
            if (!filePath.isDirectory() || !ioFile.exists() || !Status.CHECKED_OUT.equals(status = this.host.getStatus(ioFile))) continue;
            this.host.checkinFile(ioFile, comment, errors);
        }
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    private static void clearTemporaryStatuses(List<Change> changes) {
        for (Change change : changes) {
            FilePath filePath;
            VirtualFile file;
            ContentRevision rev = change.getAfterRevision();
            if (rev == null || (file = (filePath = rev.getFile()).getVirtualFile()) == null) continue;
            file.putUserData(TransparentVcs.MERGE_CONFLICT, null);
        }
    }

    private void storeChangeListName(List<Change> changes) {
        if (changes.size() > 0) {
            ChangeListManager mgr = ChangeListManager.getInstance((Project)this.project);
            LocalChangeList change = mgr.getChangeList(changes.get(0));
            this.submittedChangeListName = change.getName();
        }
    }

    private void adjustChangesWithRenamedParentFolders(List<Change> changes) {
        Set<VirtualFile> renamedFolders = this.getNecessaryRenamedFoldersForList(changes);
        if (renamedFolders.size() > 0) {
            for (VirtualFile folder : renamedFolders) {
                changes.add(ChangeListManager.getInstance((Project)this.project).getChange(folder));
            }
        }
    }

    private void commitRenamedFolders(List<Change> changes, String comment, List<VcsException> errors) {
        for (Change change : changes) {
            if (!VcsUtil.isRenameChange((Change)change) || !VcsUtil.isChangeForFolder((Change)change)) continue;
            FilePath newFile = change.getAfterRevision().getFile();
            FilePath oldFile = change.getBeforeRevision().getFile();
            if (oldFile.getVirtualFileParent().getPath().equals(newFile.getVirtualFileParent().getPath())) {
                this.host.renameAndCheckInFile(oldFile.getIOFile(), newFile.getName(), comment, errors);
            } else {
                this.host.moveRenameAndCheckInFile(oldFile.getPath(), newFile.getVirtualFileParent().getPath(), newFile.getName(), comment, errors);
            }
            this.host.renamedFolders.remove(newFile.getPath());
            this.incrementProgress(newFile.getPath());
        }
    }

    private void commitNew(List<Change> changes, String comment, HashSet<FilePath> processedFiles, List<VcsException> errors) {
        HashSet<FilePath> files = new HashSet<FilePath>();
        HashSet<FilePath> folders = new HashSet<FilePath>();
        HashSet<FilePath> checkedOutFolders = new HashSet<FilePath>();
        this.collectNewFilesAndFolders(changes, processedFiles, folders, files);
        this.addFoldersAndCheckoutParents(folders, checkedOutFolders, comment, errors);
        this.checkoutParentFoldersForFiles(files, checkedOutFolders, comment, errors);
        this.addFiles(files, comment, errors);
        this.setActivitiesForFiles(files, errors);
        this.checkinParentFolders(checkedOutFolders, comment, errors);
    }

    private void collectNewFilesAndFolders(List<Change> changes, HashSet<FilePath> processedFiles, HashSet<FilePath> folders, HashSet<FilePath> files) {
        for (Change change : changes) {
            if (!VcsUtil.isChangeForNew((Change)change)) continue;
            FilePath filePath = change.getAfterRevision().getFile();
            if (filePath.isDirectory()) {
                folders.add(filePath);
                this.analyzeParent(filePath, folders);
                continue;
            }
            files.add(filePath);
            this.analyzeParent(filePath, folders);
        }
        processedFiles.addAll(folders);
        processedFiles.addAll(files);
    }

    private void addFoldersAndCheckoutParents(HashSet<FilePath> folders, HashSet<FilePath> checkedOutFolders, String comment, List<VcsException> errors) {
        FilePath[] foldersSorted = folders.toArray(new FilePath[folders.size()]);
        foldersSorted = VcsUtil.sortPathsFromOutermost((FilePath[])foldersSorted);
        this.initProgress(foldersSorted.length);
        for (FilePath folder : foldersSorted) {
            FilePath parentFolder = folder.getParentPath();
            try {
                this.host.checkoutFile(parentFolder.getIOFile(), false, comment, true, false);
                checkedOutFolders.add(parentFolder);
                this.incrementProgress(CHECKOUT_FOLDER + parentFolder.getName());
            }
            catch (VcsException e) {
                errors.add(e);
            }
            this.host.addFileToCheckedoutFolder(folder.getIOFile(), comment, errors);
            this.host.deleteNewFile(folder.getVirtualFile());
        }
    }

    private void checkoutParentFoldersForFiles(HashSet<FilePath> files, HashSet<FilePath> checkedOutFolders, String comment, List<VcsException> errors) {
        for (FilePath file : files) {
            FilePath folder = file.getParentPath();
            if (checkedOutFolders.contains(folder)) continue;
            try {
                this.host.checkoutFile(folder.getIOFile(), false, comment, true, false);
                checkedOutFolders.add(folder);
            }
            catch (VcsException e) {
                errors.add(e);
            }
        }
    }

    private void addFiles(HashSet<FilePath> files, String comment, List<VcsException> errors) {
        this.initProgress(files.size());
        for (FilePath file : files) {
            this.host.addFileToCheckedoutFolder(file.getIOFile(), comment, errors);
            this.host.deleteNewFile(file.getVirtualFile());
            String showString = file.getName();
            if (file.getVirtualFileParent() != null) {
                showString = file.getVirtualFileParent().getName() + "/" + file.getName();
            }
            this.incrementProgress(ADDING_FILES + showString);
        }
    }

    private void setActivitiesForFiles(HashSet<FilePath> files, List<VcsException> errors) {
        if (CCaseSharedConfig.getInstance(this.project).isUseUcmModel()) {
            CCaseViewsManager viewsManager = CCaseViewsManager.getInstance(this.project);
            this.initProgress(files.size());
            for (FilePath file : files) {
                String activity = viewsManager.getActivityOfViewOfFile(file);
                String currentActivity = this.getChangeListName(file);
                if (activity != null && !activity.equals(currentActivity)) {
                    this.host.changeActivityForLastVersion(file, activity, currentActivity, errors);
                }
                this.incrementProgress(CHANGE_ACTIVITY + file.getName());
            }
        }
    }

    private void checkinParentFolders(HashSet<FilePath> folders, String comment, List<VcsException> errors) {
        this.initProgress(folders.size());
        for (FilePath folder : folders) {
            this.host.checkinFile(folder, comment, errors);
            this.incrementProgress(CHECKIN_FOLDER + folder.getName());
        }
    }

    private void analyzeParent(FilePath file, HashSet<FilePath> folders) {
        VirtualFile parent = file.getVirtualFileParent();
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(parent);
        if (status == FileStatus.ADDED || status == FileStatus.UNKNOWN) {
            FilePath parentPath = file.getParentPath();
            folders.add(parentPath);
            this.analyzeParent(parentPath, folders);
        }
    }

    private void commitDeleted(List<Change> changes, String comment, List<VcsException> errors) {
        for (Change change : changes) {
            if (!VcsUtil.isChangeForDeleted((Change)change)) continue;
            FilePath fp = change.getBeforeRevision().getFile();
            this.host.removeFile(fp.getIOFile(), comment, errors);
            String path = VcsUtil.getCanonicalLocalPath((String)fp.getPath());
            this.host.deletedFiles.remove(path);
            this.host.deletedFolders.remove(path);
            this.incrementProgress(fp.getPath());
            VcsDirtyScopeManager.getInstance((Project)this.project).fileDirty(fp);
        }
    }

    private void commitChanged(List<Change> changes, String comment, HashSet<FilePath> processedFiles, List<VcsException> errors) {
        for (Change change : changes) {
            if (VcsUtil.isChangeForNew((Change)change) || VcsUtil.isChangeForDeleted((Change)change) || VcsUtil.isChangeForFolder((Change)change)) continue;
            FilePath file = change.getAfterRevision().getFile();
            String newPath = file.getPath();
            String oldPath = this.host.renamedFiles.get(newPath);
            if (oldPath != null) {
                FilePath oldFile = change.getBeforeRevision().getFile();
                if (Comparing.equal((Object)oldFile.getParentPath(), (Object)file.getParentPath())) {
                    this.host.renameAndCheckInFile(oldFile.getIOFile(), file.getName(), comment, errors);
                } else {
                    String newFolder = file.getVirtualFileParent().getPath();
                    this.host.moveRenameAndCheckInFile(oldPath, newFolder, file.getName(), comment, errors);
                }
                this.host.renamedFiles.remove(newPath);
            } else {
                String activity;
                this.host.checkinFile(file, comment, errors);
                CCaseViewsManager viewsManager = CCaseViewsManager.getInstance(this.project);
                if (CCaseSharedConfig.getInstance(this.project).isUseUcmModel() && viewsManager.isUcmViewForFile(file) && (activity = viewsManager.getCheckoutActivityForFile(file.getPath())) != null && !activity.equals(this.submittedChangeListName)) {
                    TransparentVcs.LOG.info(" --changeActivityForLastVersion - activities do not coinside: [" + activity + "] vs [" + this.submittedChangeListName + "]");
                    this.host.changeActivityForLastVersion(file, activity, this.submittedChangeListName, errors);
                }
            }
            processedFiles.add(file);
            this.incrementProgress(file.getPath());
        }
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> paths) {
        ArrayList<VcsException> errors = new ArrayList<VcsException>();
        for (FilePath file : paths) {
            String path = VcsUtil.getCanonicalLocalPath((String)file.getPath());
            if (this.host.removedFiles.contains(path) || this.host.removedFolders.contains(path)) {
                this.host.removeFile(file.getIOFile(), null, errors);
            }
            this.host.removedFiles.remove(path);
            this.host.removedFolders.remove(path);
        }
        return errors;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        ArrayList<VcsException> vcsExceptions = new ArrayList<VcsException>();
        try {
            this.host.add2NewFiles(files);
        }
        catch (VcsException e) {
            vcsExceptions.add(e);
        }
        VcsDirtyScopeManager.getInstance((Project)this.project).filesDirty(files, null);
        return vcsExceptions;
    }

    private void extendStatus(VirtualFile file) throws VcsException {
        VirtualFile parent;
        FileStatusManager mgr = FileStatusManager.getInstance((Project)this.project);
        if (mgr.getStatus(parent = file.getParent()) == FileStatus.UNKNOWN) {
            this.host.add2NewFile(parent);
            VcsUtil.markFileAsDirty((Project)this.project, (VirtualFile)parent);
            this.extendStatus(parent);
        }
    }

    private Set<VirtualFile> getNecessaryRenamedFoldersForList(List<Change> changes) {
        ContentRevision rev;
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (Change change : changes) {
            rev = change.getAfterRevision();
            if (rev == null) continue;
            for (String newFolderName : this.host.renamedFolders.keySet()) {
                if (!rev.getFile().getPath().startsWith(newFolderName)) continue;
                VirtualFile parent = VcsUtil.getVirtualFile((String)newFolderName);
                set.add(parent);
            }
        }
        for (Change change : changes) {
            VirtualFile submittedParent;
            rev = change.getAfterRevision();
            if (rev == null || (submittedParent = rev.getFile().getVirtualFile()) == null) continue;
            set.remove(submittedParent);
        }
        return set;
    }

    @Nullable
    private String getChangeListName(@NotNull FilePath file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "net/sourceforge/transparent/Checkin/CCaseCheckinEnvironment", "getChangeListName"));
        }
        String changeListName = null;
        ChangeListManager mgr = ChangeListManager.getInstance((Project)this.project);
        Change change = mgr.getChange(file);
        if (change != null) {
            changeListName = mgr.getChangeList(change).getName();
        }
        return changeListName;
    }

    private void initProgress(int total) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            this.fraction = 1.0 / (double)total;
            progress.setIndeterminate(false);
            progress.setFraction(0.0);
        }
    }

    private void incrementProgress(String text) throws ProcessCanceledException {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            double newFraction = progress.getFraction();
            progress.setFraction(newFraction += this.fraction);
            progress.setText(text);
            if (progress.isCanceled()) {
                throw new ProcessCanceledException();
            }
        }
    }
}

