/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;

public abstract class VcsAction
extends AnAction {
    @NonNls
    private static final String OPERATION_FAILED_TEXT = "One or more errors occured during operation";

    public void update(AnActionEvent e) {
        String actionName = this.getActionName(e);
        if (actionName == null) {
            throw new IllegalStateException("Internal error - Action Name is NULL.");
        }
        e.getPresentation().setText(actionName);
    }

    protected abstract String getActionName(AnActionEvent var1);

    protected void execute(AnActionEvent e, List<VcsException> errors) {
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FileDocumentManager.getInstance().saveAllDocuments();
        List<VcsException> errors = this.runAction(e);
        if (errors.size() > 0) {
            String title = this.getActionName(e) + " failed";
            AbstractVcsHelper.getInstance((Project)project).showErrors(errors, title);
            Messages.showErrorDialog((Project)project, (String)OPERATION_FAILED_TEXT, (String)title);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<VcsException> runAction(AnActionEvent e) {
        ArrayList<VcsException> list = new ArrayList<VcsException>();
        LocalHistoryAction a = LocalHistory.getInstance().startAction(e.getPresentation().getText());
        try {
            this.execute(e, list);
        }
        finally {
            a.finish();
        }
        return list;
    }

    protected static FileStatus getFileStatus(Project project, VirtualFile file) {
        ChangeListManager mgr = ChangeListManager.getInstance((Project)project);
        return mgr.getStatus(file);
    }

    protected static TransparentVcs getHost(AnActionEvent e) {
        return TransparentVcs.getInstance((Project)e.getData(CommonDataKeys.PROJECT));
    }
}

