/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.CustomJsfVariableResolverProvider;
import com.intellij.spring.el.SpringBeansAsElVariableUtil;
import com.intellij.spring.integration.ContextImplicitVariable;
import com.intellij.spring.integration.ContextImplicitVariableFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class SpringWebApplicationContextVariableResolverProvider
implements CustomJsfVariableResolverProvider {
    @NonNls
    private static final List<String> VARIABLE_RESOLVER_CLASS_NAMES = Arrays.asList("org.springframework.web.jsf.WebApplicationContextVariableResolver", "org.springframework.web.jsf.el.WebApplicationContextFacesELResolver");
    @NonNls
    private static final String WEB_APPLICATION_CONTEXT_VARIABLE_NAME = "webApplicationContext";

    public boolean acceptVariableResolver(String className, Module module) {
        return VARIABLE_RESOLVER_CLASS_NAMES.contains(className);
    }

    public void addVars(List<PsiVariable> resultVars, final Module module) {
        Factory<List<PsiVariable>> factory = new Factory<List<PsiVariable>>(){

            public List<PsiVariable> create() {
                ArrayList<PsiVariable> results = new ArrayList<PsiVariable>();
                SpringBeansAsElVariableUtil.addVariables(results, (Module)module);
                return results;
            }
        };
        ContextImplicitVariable contextVariable = ContextImplicitVariableFactory.getInstance(module).createContextVariable(WEB_APPLICATION_CONTEXT_VARIABLE_NAME, factory);
        resultVars.add((PsiVariable)contextVariable);
    }
}

