/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.hibernate.engine.HibernateConsole;
import com.intellij.hibernate.engine.HibernateEngine;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaConsoleProvider;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import icons.HibernateCoreIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConsoleProvider
extends PersistenceConsoleProvider {
    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/hibernate/HibernateConsoleProvider", "hasRunners"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        return project != null && facet != null && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit) && facet.getQlLanguage() != null && HibernateEngine.isAvailable(facet.getModule());
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/hibernate/HibernateConsoleProvider", "hasRunners"));
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !HibernateEngine.isAvailable(module)) {
            return false;
        }
        return JpaConsoleProvider.findQlFile((PsiFile)file, (PsiElement)element) != null;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        boolean enable;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        boolean bl = enable = project != null && facet != null && unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit) && facet.getQlLanguage() != null && HibernateEngine.isAvailable(facet.getModule());
        if (!enable) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
            }
            return list;
        }
        PersistencePackageAsVirtualFileImpl unitFile = PersistencePackageAsVirtualFileImpl.findFile((PersistencePackage)unit, (PersistenceFacet)facet);
        if (unitFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add((PersistenceConsoleProvider.Runner)new MyRunner(project, unitFile));
        HibernateConsoleProvider.addDefaultRunners(result, project, (PersistencePackagePointer)unitFile, null);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
        }
        return arrayList;
    }

    private static void addDefaultRunners(Collection<PersistenceConsoleProvider.Runner> result, Project project, PersistencePackagePointer unit, QlScriptModel queryText) {
        for (HibernateConsole console : HibernateConsole.getActiveConsoles(project)) {
            if (!((PersistencePackagePointer)console.getTarget()).equals(unit)) continue;
            result.add((PersistenceConsoleProvider.Runner)new JpaConsoleProvider.MyConsoleRunner((JpaConsoleBase)console, (ScriptModel)queryText));
        }
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, Editor editor) {
        QlScriptModel model;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !HibernateEngine.isAvailable(module)) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
            }
            return list;
        }
        ArrayList<PersistencePackagePointer> unitFiles = new ArrayList<PersistencePackagePointer>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
            if (facet.getQlLanguage() == null) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                if (!JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit)) continue;
                ContainerUtil.addIfNotNull((Object)PersistencePackageAsVirtualFileImpl.findFile((PersistencePackage)unit, (PersistenceFacet)facet), unitFiles);
            }
        }
        if (unitFiles.isEmpty()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
            }
            return list;
        }
        QlFile qlFile = JpaConsoleProvider.findQlFile((PsiFile)file, (PsiElement)element);
        QlScriptModel qlScriptModel = model = qlFile == null ? null : JpaConsoleProvider.createScriptModel((PsiFile)file, (QlFile)qlFile);
        if (model == null || !model.statements().hasNext()) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add((PersistenceConsoleProvider.Runner)new MyQueryRunner(module.getProject(), unitFiles, model));
        for (PersistencePackagePointer unit : unitFiles) {
            HibernateConsoleProvider.addDefaultRunners(result, module.getProject(), unit, model);
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/HibernateConsoleProvider", "getRunners"));
        }
        return arrayList;
    }

    private static class MyQueryRunner
    extends JpaConsoleProvider.MyQueryRunner {
        public MyQueryRunner(Project project, List<PersistencePackagePointer> unitFiles, QlScriptModel model) {
            super(project, unitFiles, model);
        }

        public String getDisplayName() {
            return "Hibernate Console";
        }

        public Icon getIcon() {
            return HibernateCoreIcons.AddHibernateSupport;
        }

        protected void runInner(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, @NotNull QlScriptModel model) {
            if (unit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/HibernateConsoleProvider$MyQueryRunner", "runInner"));
            }
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/hibernate/HibernateConsoleProvider$MyQueryRunner", "runInner"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/hibernate/HibernateConsoleProvider$MyQueryRunner", "runInner"));
            }
            String text = (String)model.statements().asCursor().transform(ScriptModelUtil.TO_TEXT).first();
            HibernateConsole console = (HibernateConsole)((Object)HibernateConsole.newConsole(unit).withRunConfiguration(configuration).withQuery((CharSequence)text).build());
            console.showConsole(false);
            if (console.beforeExecuteQueries((ScriptModel)model)) {
                console.executeQueries((Editor)console.getLanguageConsole().getCurrentEditor(), (ScriptModel)model);
            }
        }
    }

    private static class MyRunner
    extends JpaConsoleProvider.MyRunner {
        private final PersistencePackageAsVirtualFileImpl myUnitFile;

        public MyRunner(Project project, PersistencePackageAsVirtualFileImpl unitFile) {
            super(project, unitFile);
            this.myUnitFile = unitFile;
        }

        public String getDisplayName() {
            return "Hibernate Console";
        }

        public Icon getIcon() {
            return HibernateCoreIcons.AddHibernateSupport;
        }

        protected void runInner(ConsoleRunConfiguration configuration) {
            ((HibernateConsole)((Object)HibernateConsole.newConsole((PersistencePackagePointer)this.myUnitFile).withRunConfiguration(configuration).build())).showConsole(true);
        }
    }
}

