/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.hibernate.HibernateMessages;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateFacetConfiguration;
import com.intellij.hibernate.facet.HibernateFacetType;
import com.intellij.hibernate.model.HibernateConstants;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.model.xml.config.HibernateConfiguration;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConfigDomFacetInspection
extends BasicDomElementsInspection<HibernateConfiguration> {
    public HibernateConfigDomFacetInspection() {
        super(HibernateConfiguration.class, new Class[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = HibernateConstants.HIBERNATE_INSPECTIONS_GROUP;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = HibernateMessages.message("inspection.name.hibernate.configuration.facet", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("HibernateConfigDomFacetInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection", "getShortName"));
        }
        return "HibernateConfigDomFacetInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public void checkFileElement(DomFileElement<HibernateConfiguration> element, DomElementAnnotationHolder holder) {
        Module[] modulesToLookAt;
        Module elementModule = element.getModule();
        VirtualFile virtualFile = element.getFile().getVirtualFile();
        assert (virtualFile != null);
        boolean found = false;
        Project project = element.getManager().getProject();
        Module[] moduleArray = modulesToLookAt = elementModule == null ? ModuleManager.getInstance((Project)project).getModules() : JamCommonUtil.getAllDependentModules((Module)elementModule);
        if (modulesToLookAt.length == 0) {
            return;
        }
        List<HibernateFacet> facets = HibernateConfigDomFacetInspection.collectFacets(modulesToLookAt);
        for (HibernateFacet facet : facets) {
            for (ConfigFile configFile : facet.getDescriptors()) {
                if (HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA != configFile.getMetaData() || !virtualFile.equals(configFile.getVirtualFile())) continue;
                found = true;
            }
        }
        if (!found) {
            for (HibernateFacet facet : facets) {
                if (!facet.getPersistenceUnits().contains(((HibernateConfiguration)element.getRootElement()).getSessionFactory())) continue;
                found = true;
                break;
            }
        }
        if (facets.isEmpty()) {
            holder.createProblem(element, HighlightSeverity.WARNING, HibernateMessages.message("warning.cfg.xml.not.in.any.facet", new Object[0]), new LocalQuickFix[]{new AddFacetFix(modulesToLookAt)});
        } else if (!found) {
            holder.createProblem(element, HighlightSeverity.WARNING, HibernateMessages.message("warning.cfg.xml.not.in.any.facet", new Object[0]), new LocalQuickFix[]{new AddToFacetConfigurationFix(modulesToLookAt)});
        }
    }

    private static List<HibernateFacet> collectFacets(Module[] modulesToLookAt) {
        return ContainerUtil.concat((Object[])modulesToLookAt, (Function)new Function<Module, Collection<? extends HibernateFacet>>(){

            public Collection<? extends HibernateFacet> fun(Module module) {
                return FacetManager.getInstance((Module)module).getFacetsByType(HibernateFacet.ID);
            }
        });
    }

    private static class AddFacetFix
    extends AddToFacetConfigurationFix {
        public AddFacetFix(Module[] modules) {
            super(modules);
        }

        @Override
        @NotNull
        public String getName() {
            String string = HibernateMessages.message("name.fix.create.facet.and.add.to.facet.configuration", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddFacetFix", "getName"));
            }
            return string;
        }
    }

    private static class AddToFacetConfigurationFix
    extends IntentionAndQuickFixAction {
        private final Module[] myModules;

        public AddToFacetConfigurationFix(Module[] modules) {
            this.myModules = modules;
        }

        @NotNull
        public String getName() {
            String string = HibernateMessages.message("name.fix.add.to.facet.configuration", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddToFacetConfigurationFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = HibernateMessages.message("hibernate.quickfix.family", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddToFacetConfigurationFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddToFacetConfigurationFix", "applyFix"));
            }
            this.doFix(project, file.getVirtualFile(), editor);
        }

        private void doFix(Project project, VirtualFile file, Editor editor) {
            String url = file.getUrl();
            List facets = HibernateConfigDomFacetInspection.collectFacets(this.myModules);
            if (this.myModules.length == 1 && (facets.isEmpty() || facets.size() == 1)) {
                this.doAddToFacet(this.myModules[0], facets.isEmpty() ? null : (HibernateFacet)((Object)facets.get(0)), url);
            } else {
                ArrayList items = new ArrayList();
                ContainerUtil.addAll(items, (Object[])this.myModules);
                items.addAll(facets);
                for (HibernateFacet facet : facets) {
                    items.remove(facet.getModule());
                }
                Collections.sort(items, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return Comparing.compare((Comparable)((Object)AddToFacetConfigurationFix.getItemName(o1)), (Comparable)((Object)AddToFacetConfigurationFix.getItemName(o2)));
                    }
                });
                JBList list = new JBList(items.toArray());
                list.setCellRenderer(new ColoredListCellRenderer(){

                    protected void customizeCellRenderer(JList list, Object o, int index, boolean selected, boolean hasFocus) {
                        this.setIcon(o instanceof Module ? ModuleType.get((Module)((Module)o)).getIcon() : ((Facet)o).getType().getIcon());
                        this.append(AddToFacetConfigurationFix.getItemName(o));
                    }
                });
                new PopupChooserBuilder((JList)list).setTitle(HibernateMessages.message("popup.title.choose.module.and.facet", new Object[0])).setMovable(true).setItemChoosenCallback(new Runnable((JList)list, url){
                    final /* synthetic */ JList val$list;
                    final /* synthetic */ String val$url;
                    {
                        this.val$list = jList;
                        this.val$url = string;
                    }

                    @Override
                    public void run() {
                        Object o = this.val$list.getSelectedValue();
                        Module module = o instanceof Module ? (Module)o : ((Facet)o).getModule();
                        HibernateFacet facet = o instanceof Module ? null : (HibernateFacet)((Object)o);
                        this.doAddToFacet(module, facet, this.val$url);
                    }
                }).setFilteringEnabled((Function)new Function<Object, String>(){

                    public String fun(Object o) {
                        return AddToFacetConfigurationFix.getItemName(o);
                    }
                }).createPopup().showCenteredInCurrentWindow(project);
            }
        }

        private static String getItemName(Object o) {
            return o instanceof Module ? ((Module)o).getName() : ((Facet)o).getModule().getName() + "/" + ((Facet)o).getName();
        }

        private void doAddToFacet(final @NotNull Module module, final @Nullable HibernateFacet facet, final String url) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddToFacetConfigurationFix", "doAddToFacet"));
            }
            new WriteCommandAction.Simple(module.getProject(), this.getName(), new PsiFile[0]){

                protected void run() throws Throwable {
                    HibernateFacet chosenFacet = facet != null ? facet : (HibernateFacet)FacetManager.getInstance((Module)module).addFacet((FacetType)HibernateFacetType.getInstance(), HibernateFacetType.getInstance().getDefaultFacetName(), null);
                    ((HibernateFacetConfiguration)chosenFacet.getConfiguration()).getDescriptorsConfiguration().addConfigFile(HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA, url);
                }
            }.execute();
            DomElementAnnotationsManager.getInstance((Project)module.getProject()).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)module.getProject()).restart();
        }
    }
}

