/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleUtils {
    private static final String SEPARATOR = StringUtil.escapeBackSlashes((String)File.separator);
    private static final String NODE_MODULES_PATTERN = "*" + SEPARATOR + "node_modules" + SEPARATOR + "*";

    public static boolean containsNodeModulesPattern(@NotNull TraceProjectSettings.EventFilterState activeFilter) {
        if (activeFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeFilter", "com/intellij/javascript/trace/execution/NodeModuleUtils", "containsNodeModulesPattern"));
        }
        return NodeModuleUtils.contains(activeFilter, NODE_MODULES_PATTERN);
    }

    public static boolean containsNodeModulePattern(@NotNull TraceProjectSettings.EventFilterState activeFilter, @NotNull String module) {
        if (activeFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeFilter", "com/intellij/javascript/trace/execution/NodeModuleUtils", "containsNodeModulePattern"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/trace/execution/NodeModuleUtils", "containsNodeModulePattern"));
        }
        return NodeModuleUtils.contains(activeFilter, NodeModuleUtils.getModulePattern(module));
    }

    private static boolean contains(TraceProjectSettings.EventFilterState activeFilter, final @NotNull String conditionValue) {
        if (conditionValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditionValue", "com/intellij/javascript/trace/execution/NodeModuleUtils", "contains"));
        }
        return ContainerUtil.exists(activeFilter.getEventFilterConditions(), (Condition)new Condition<TraceProjectSettings.EventFilterConditionState>(){

            public boolean value(TraceProjectSettings.EventFilterConditionState condition) {
                return conditionValue.equals(condition.getValue());
            }
        });
    }

    public static void muteNodeModules(@NotNull TraceSettingsManager traceSettingsManager) {
        if (traceSettingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceSettingsManager", "com/intellij/javascript/trace/execution/NodeModuleUtils", "muteNodeModules"));
        }
        NodeModuleUtils.mute(traceSettingsManager, null);
    }

    public static void muteNodeModule(@NotNull TraceSettingsManager traceSettingsManager, @NotNull String nodeModule) {
        if (traceSettingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceSettingsManager", "com/intellij/javascript/trace/execution/NodeModuleUtils", "muteNodeModule"));
        }
        if (nodeModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModule", "com/intellij/javascript/trace/execution/NodeModuleUtils", "muteNodeModule"));
        }
        NodeModuleUtils.mute(traceSettingsManager, nodeModule);
    }

    private static void mute(@NotNull TraceSettingsManager traceSettingsManager, @Nullable String module) {
        if (traceSettingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceSettingsManager", "com/intellij/javascript/trace/execution/NodeModuleUtils", "mute"));
        }
        boolean specificModule = !StringUtil.isEmpty((String)module);
        String conditionValue = !specificModule ? NODE_MODULES_PATTERN : NodeModuleUtils.getModulePattern(module);
        TraceProjectSettings.EventFilterState activeFilter = traceSettingsManager.getActiveFilter();
        if (NodeModuleUtils.containsNodeModulesPattern(activeFilter)) {
            return;
        }
        if (traceSettingsManager.setAndApplyFilterByCondition(conditionValue)) {
            return;
        }
        TraceProjectSettings.EventFilterConditionState condition = new TraceProjectSettings.EventFilterConditionState();
        condition.setType("file");
        condition.setValue(conditionValue);
        traceSettingsManager.addToActiveOrCreateNewFilterAndApply(condition, specificModule ? String.format(TraceBundle.message("console.trace.toolbar.filterEvents.muteNodeModuleSuggestion", new Object[0]), module) : TraceBundle.message("console.trace.toolbar.filterEvents.muteNodeModulesSuggestion", new Object[0]));
    }

    private static String getModulePattern(String module) {
        return StringUtil.trimEnd((String)NODE_MODULES_PATTERN, (String)"*") + module + SEPARATOR + "*";
    }
}

