/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.DeferingPrinter;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpIdProvider;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.execution.TracePanel;
import com.intellij.javascript.trace.execution.TraceServerLogComponent;
import com.intellij.javascript.trace.execution.actions.CloseAllDiagramFilesAction;
import com.intellij.javascript.trace.execution.actions.CloseAllTraceFilesAction;
import com.intellij.javascript.trace.execution.common.TraceLoadedHandler;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import icons.SpyJSIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceConsoleView
implements ConsoleView,
ObservableConsoleView,
HelpIdProvider,
ExecutionConsoleEx {
    private Printer myPrinter;
    private ConsoleView myConsole;
    private TraceConsoleProperties myProperties;
    private final TraceSession myTraceSession;
    private final ExecutionEnvironment myEnvironment;
    private TracePanel myTracePanel;
    private TraceServerLogComponent myTraceServerLogComponent;
    private Content myConsoleContent;

    public TraceConsoleView(TraceConsoleProperties properties, TraceSession traceSession, ExecutionEnvironment environment) {
        this.myProperties = properties;
        this.myTraceSession = traceSession;
        this.myEnvironment = environment;
        this.myTracePanel = new TracePanel(this.myProperties.getConfiguration(), this.myEnvironment, this.myTraceSession, this.myProperties, this);
        this.myConsole = new TextConsoleBuilderImpl(properties.getProject()).getConsole();
        this.myPrinter = new DeferingPrinter();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
        this.myTraceSession.onSessionStopped(new Runnable(){

            @Override
            public void run() {
                if (TraceConsoleView.this.myProperties.needToCloseTraceFilesOnSessionStop()) {
                    CloseAllTraceFilesAction.execute(TraceConsoleView.this.myProperties.getProject());
                }
                if (TraceConsoleView.this.myProperties.needToCloseDiagramFilesOnSessionStop()) {
                    CloseAllDiagramFilesAction.execute(TraceConsoleView.this.myProperties.getProject());
                }
            }
        });
        this.myTraceSession.onTraceLoaded(new TraceLoadedHandler(){

            @Override
            public void traceLoaded(@NotNull String traceId) {
                if (traceId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceId", "com/intellij/javascript/trace/execution/TraceConsoleView$2", "traceLoaded"));
                }
                if (!StringUtil.isEmpty((String)traceId)) {
                    TraceConsoleView.this.myConsoleContent.setDisplayName(String.format(TraceBundle.message("console.trace.header.loaded", new Object[0]), traceId));
                }
            }
        });
    }

    public void initUI() {
        this.myTracePanel.initUI();
        Disposer.register((Disposable)this, (Disposable)this.myTracePanel);
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javascript/trace/execution/TraceConsoleView", "print"));
        }
        if (contentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/javascript/trace/execution/TraceConsoleView", "print"));
        }
        this.myPrinter.print(s, contentType);
    }

    public void clear() {
        this.myConsole.clear();
        if (this.myTraceServerLogComponent != null) {
            this.myTraceServerLogComponent.clear();
        }
    }

    public void scrollTo(int offset) {
        this.myConsole.scrollTo(offset);
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myConsole.attachToProcess(processHandler);
    }

    public boolean isOutputPaused() {
        return false;
    }

    public void setOutputPaused(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean hasDeferredOutput() {
        return this.myConsole.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(Runnable runnable) {
        this.myConsole.performWhenNoDeferredOutput(runnable);
    }

    public void addMessageFilter(Filter filter) {
        this.myConsole.addMessageFilter(filter);
    }

    public void printHyperlink(String hyperlinkText, HyperlinkInfo info) {
        this.printNew((Printable)new HyperLink(hyperlinkText, info));
    }

    private void printNew(Printable printable) {
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public int getContentSize() {
        return this.myConsole.getContentSize();
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TraceConsoleView", "createConsoleActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTracePanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTracePanel;
    }

    @Nullable
    public String getHelpId() {
        return TraceBundle.message("console.helpId", new Object[0]);
    }

    public void setHelpId(String helpId) {
        this.myConsole.setHelpId(helpId);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/trace/execution/TraceConsoleView", "addChangeListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/TraceConsoleView", "addChangeListener"));
        }
        ((ObservableConsoleView)this.myConsole).addChangeListener(listener, parent);
    }

    public void buildUi(RunnerLayoutUi layoutUi) {
        this.registerTraceTab(layoutUi);
        this.registerProxyTab(layoutUi);
    }

    private void registerTraceTab(RunnerLayoutUi layoutUi) {
        layoutUi.getOptions().setMinimizeActionEnabled(false);
        this.myConsoleContent = layoutUi.createContent("ConsoleContent", this.getComponent(), TraceBundle.message("console.trace.header", new Object[0]), SpyJSIcons.Spy_js_run, this.getPreferredFocusableComponent());
        layoutUi.addContent(this.myConsoleContent, 1, PlaceInGrid.bottom, false);
        this.myConsoleContent.setCloseable(false);
    }

    private void registerProxyTab(RunnerLayoutUi layoutUi) {
        this.myTraceServerLogComponent = new TraceServerLogComponent(this.myEnvironment.getProject(), (Disposable)this, (AnAction)new StopProcessAction(TraceBundle.message("console.server.label.stop", new Object[0]), TraceBundle.message("console.server.description.stop", new Object[0]), this.myTraceSession.getProcessHandler()));
        layoutUi.getOptions().setMinimizeActionEnabled(false);
        final Content consoleContent = layoutUi.createContent(TraceBundle.message("console.server.consoleContentId", new Object[0]), (ComponentWithActions)this.myTraceServerLogComponent, this.myTraceSession.isNodeJsSession() ? TraceBundle.message("console.server.node.header", new Object[0]) : TraceBundle.message("console.server.header", new Object[0]), AllIcons.Debugger.Console, this.getPreferredFocusableComponent());
        layoutUi.addContent(consoleContent, 2, PlaceInGrid.bottom, false);
        consoleContent.setCloseable(false);
        this.myTraceSession.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                TraceConsoleView.this.myTraceServerLogComponent.print(text, ConsoleViewContentType.getConsoleViewType((Key)outputType));
                if (outputType.equals((Object)ProcessOutputTypes.STDERR)) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            consoleContent.fireAlert();
                        }
                    }, ModalityState.any());
                }
            }
        });
    }

    @Nullable
    public String getExecutionConsoleId() {
        return null;
    }

    public void dispose() {
    }

    public TracePanel getTracePanel() {
        return this.myTracePanel;
    }
}

