/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import icons.SpyJSIcons;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#.####");

    public static String getShortFileName(String url) {
        return Utils.getShortFileName(url, 50);
    }

    private static String getShortFileNameWithExtension(String url, int max) {
        if (StringUtil.isEmpty((String)url)) {
            return url;
        }
        int sepIndex = Math.max(url.lastIndexOf("/"), url.lastIndexOf("\\"));
        String shortName = url.substring(sepIndex + 1);
        int end = (url = shortName.isEmpty() ? url : shortName).lastIndexOf("?");
        if (end > 0) {
            shortName = url.substring(0, end);
            String string = url = shortName.isEmpty() ? url : shortName;
        }
        if (max > 0) {
            return StringUtil.first((String)url, (int)max, (boolean)true);
        }
        return url;
    }

    public static String getShortFileNameWithExtension(String url) {
        return Utils.getShortFileNameWithExtension(url, 35);
    }

    public static String getFileNameWithExtension(String url) {
        return Utils.getShortFileNameWithExtension(url, Integer.MAX_VALUE);
    }

    public static String getShortFileName(String url, int max) {
        String shortName;
        int end = (url = Utils.getShortFileNameWithExtension(url, 0)).lastIndexOf(".min.js");
        if (end > 0) {
            shortName = url.substring(0, end);
            String string = url = shortName.isEmpty() ? url : shortName;
        }
        if ((end = url.lastIndexOf(".js")) > 0) {
            shortName = url.substring(0, end);
            String string = url = shortName.isEmpty() ? url : shortName;
        }
        if (max > 0) {
            return StringUtil.first((String)url, (int)max, (boolean)true);
        }
        return url;
    }

    public static String getServerScriptPath(String scriptFileName, boolean useDist) {
        if (useDist) {
            String jarPath = PathUtil.getJarPathForClass(Utils.class);
            File jarFile = new File(jarPath);
            if (!jarPath.endsWith(".jar")) {
                return new File(jarPath, "server/" + scriptFileName).getPath();
            }
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, "server/" + scriptFileName).getPath();
        }
        String jarPath = PathUtil.getJarPathForClass(Utils.class);
        File jarFile = new File(jarPath);
        File rootDir = jarFile.getParentFile().getParentFile().getParentFile().getParentFile();
        return new File(rootDir, "plugins/spy-js/server/" + scriptFileName).getPath();
    }

    public static String formatExecutionTime(double time) {
        try {
            return TIME_FORMAT.format(time);
        }
        catch (Exception ignored) {
            return "-";
        }
    }

    @Nullable
    public static BrowserFamily getBrowserFamily(@NotNull String agent) {
        if (agent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agent", "com/intellij/javascript/trace/execution/Utils", "getBrowserFamily"));
        }
        if (agent.startsWith("Chrome")) {
            return BrowserFamily.CHROME;
        }
        if (agent.startsWith("Safari") || agent.startsWith("Mobile Safari")) {
            return BrowserFamily.SAFARI;
        }
        if (agent.startsWith("Opera")) {
            return BrowserFamily.OPERA;
        }
        if (agent.startsWith("Firefox")) {
            return BrowserFamily.FIREFOX;
        }
        if (agent.startsWith("IE")) {
            return BrowserFamily.EXPLORER;
        }
        return null;
    }

    @NotNull
    private static Icon getBrowserIcon(@Nullable BrowserFamily browserFamily, @NotNull String agent) {
        if (agent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agent", "com/intellij/javascript/trace/execution/Utils", "getBrowserIcon"));
        }
        if (browserFamily != null) {
            Icon icon = browserFamily.getIcon();
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/Utils", "getBrowserIcon"));
            }
            return icon;
        }
        if (agent.startsWith("Yandex")) {
            Icon icon = AllIcons.Xml.Browsers.Yandex16;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/Utils", "getBrowserIcon"));
            }
            return icon;
        }
        Icon icon = SpyJSIcons.CommonBrowser;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/Utils", "getBrowserIcon"));
        }
        return icon;
    }

    @NotNull
    public static Icon getAgentIcon(@NotNull String agent) {
        if (agent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agent", "com/intellij/javascript/trace/execution/Utils", "getAgentIcon"));
        }
        if (Utils.isNodeJsAgent(agent)) {
            Icon icon = SpyJSIcons.Nodejs_16;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/Utils", "getAgentIcon"));
            }
            return icon;
        }
        Icon icon = Utils.getBrowserIcon(Utils.getBrowserFamily(agent), agent);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/Utils", "getAgentIcon"));
        }
        return icon;
    }

    public static boolean isNodeJsAgent(@NotNull String agent) {
        if (agent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "agent", "com/intellij/javascript/trace/execution/Utils", "isNodeJsAgent"));
        }
        return agent.equals("node.js");
    }

    static {
        TIME_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }
}

