/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.TraceRangeValue;
import com.intellij.javascript.trace.execution.context.FunctionSummaryValue;
import com.intellij.javascript.trace.execution.context.ParameterValue;
import com.intellij.javascript.trace.execution.context.ReturnValue;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TraceVirtualFile
extends LightVirtualFile {
    private static final int FUNC_KEYWORD_LENGTH = "function".length();
    private static final int RET_KEYWORD_LENGTH = "return".length();
    public static final String TRACE_POSTFIX = " trace";
    private final String myPath;
    private final List<Runnable> myContextChangedHandlers = new ArrayList<Runnable>();
    private final List<TraceRangeValue> myRangeValues = new ArrayList<TraceRangeValue>();
    private StackFrameContext myContext;
    private final VirtualFile myLocalFile;
    private String myStreamId;

    public TraceVirtualFile(String url, String content, VirtualFile localFile, String streamId) {
        super((localFile != null ? localFile.getPresentableName() : Utils.getShortFileNameWithExtension(url)) + TRACE_POSTFIX, (CharSequence)content);
        this.myPath = url;
        this.myLocalFile = localFile;
        this.myStreamId = streamId;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "getPath"));
        }
        return string;
    }

    @NotNull
    public TraceRangeValue[] getActiveRangeValues() {
        TraceRangeValue[] traceRangeValueArray = this.myRangeValues.toArray(new TraceRangeValue[this.myRangeValues.size()]);
        if (traceRangeValueArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "getActiveRangeValues"));
        }
        return traceRangeValueArray;
    }

    public void updateRangeValues(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "updateRangeValues"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "updateRangeValues"));
        }
        this.myRangeValues.clear();
        Document document = editor.getDocument();
        RuntimeFunctionScope activeScope = this.myContext.getStackFrame();
        TextRange functionRange = this.getFunctionRange(editor, activeScope);
        if (activeScope.isDumpCaptured() && !activeScope.isProgram().booleanValue()) {
            TextRange returnStatementRange;
            for (RuntimeFunctionArgument argument : activeScope.getArguments()) {
                if (!argument.hasRange()) continue;
                TextRange paramRange = this.getParamRange(editor, argument);
                int startLine = document.getLineNumber(paramRange.getStartOffset());
                int endLine = document.getLineNumber(paramRange.getEndOffset());
                int startColumn = paramRange.getStartOffset() - document.getLineStartOffset(startLine);
                int endColumn = paramRange.getEndOffset() - document.getLineStartOffset(endLine);
                if (paramRange.equals((Object)TextRange.EMPTY_RANGE)) continue;
                this.myRangeValues.add(new TraceRangeValue(document, new CodeRange(startLine + 1, endLine + 1, startColumn, endColumn), new ParameterValue(argument)));
            }
            if (!functionRange.equals((Object)TextRange.EMPTY_RANGE) && PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)functionRange.getStartOffset()).getTextLength() == FUNC_KEYWORD_LENGTH) {
                this.myRangeValues.add(new TraceRangeValue(new TextRange(functionRange.getStartOffset(), functionRange.getStartOffset() + FUNC_KEYWORD_LENGTH), new FunctionSummaryValue(this.myContext)));
            }
            if (activeScope.hasReturnValue() && !(returnStatementRange = this.getReturnStatementRange(editor, activeScope.getReturnStatement())).equals((Object)TextRange.EMPTY_RANGE)) {
                int contextLength = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)returnStatementRange.getStartOffset()).getTextLength();
                this.myRangeValues.add(new TraceRangeValue(contextLength == RET_KEYWORD_LENGTH ? new TextRange(returnStatementRange.getStartOffset(), returnStatementRange.getStartOffset() + contextLength) : returnStatementRange, new ReturnValue(activeScope.getReturnValue())));
            }
        }
    }

    public void addContextChangedHandler(Runnable contextChangedHandler) {
        this.myContextChangedHandlers.add(contextChangedHandler);
    }

    public void setContext(@NotNull StackFrameContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "setContext"));
        }
        this.myContext = context;
        for (Runnable handler : this.myContextChangedHandlers) {
            handler.run();
        }
    }

    public VirtualFile getProjectFile() {
        return this.myLocalFile;
    }

    @NotNull
    public TextRange getCurrentScopeApproxRange(final @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "getCurrentScopeApproxRange"));
        }
        final RuntimeFunctionScope functionScope = this.myContext.getStackFrame();
        TextRange functionRange = this.getFunctionRange(editor, functionScope);
        if (functionRange != TextRange.EMPTY_RANGE) {
            TextRange textRange = functionRange;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "getCurrentScopeApproxRange"));
            }
            return textRange;
        }
        int minOffset = editor.getDocument().getTextLength();
        int maxOffset = 0;
        for (TextRange range : ContainerUtil.concat((List)ContainerUtil.map(this.myRangeValues, (Function)new Function<TraceRangeValue, TextRange>(){

            public TextRange fun(TraceRangeValue value) {
                return value.getTextRange();
            }
        }), (List)ContainerUtil.map((Object[])functionScope.getStatements(), (Function)new Function<RuntimeStatement, TextRange>(){

            public TextRange fun(RuntimeStatement statement) {
                return TraceVirtualFile.this.getStatementRange(editor, functionScope, statement.getCodeElement());
            }
        }))) {
            if (range == TextRange.EMPTY_RANGE) continue;
            if (range.getStartOffset() < minOffset) {
                minOffset = range.getStartOffset();
            }
            if (range.getEndOffset() <= maxOffset) continue;
            maxOffset = range.getEndOffset();
        }
        TextRange textRange = maxOffset > minOffset ? new TextRange(minOffset, maxOffset) : TextRange.EMPTY_RANGE;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "getCurrentScopeApproxRange"));
        }
        return textRange;
    }

    @NotNull
    public abstract TextRange getFunctionRange(@NotNull Editor var1, @NotNull RuntimeFunctionScope var2);

    @NotNull
    public abstract TextRange getStatementRange(@NotNull Editor var1, @NotNull RuntimeFunctionScope var2, @NotNull StaticCodeElement var3);

    @NotNull
    public abstract TextRange getReturnStatementRange(@NotNull Editor var1, @NotNull RuntimeReturnStatement var2);

    @NotNull
    public abstract TextRange getParamRange(@NotNull Editor var1, @NotNull RuntimeFunctionArgument var2);

    public StackFrameContext getCurrentContext() {
        return this.myContext;
    }

    @NotNull
    public String getStreamId() {
        String string = this.myStreamId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "getStreamId"));
        }
        return string;
    }

    @Nullable
    public String getLineExtension(@NotNull Editor editor, int lineNumber) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/javascript/trace/execution/common/TraceVirtualFile", "getLineExtension"));
        }
        TextRange activeFunctionRange = this.getCurrentScopeApproxRange(editor);
        int startLine = editor.getDocument().getLineNumber(activeFunctionRange.getStartOffset());
        if (startLine != lineNumber) {
            return null;
        }
        Double time = this.myContext.getStackFrame().getExecutionTime();
        if (time == null) {
            return null;
        }
        return String.format(TraceBundle.message("console.trace.funcExecutedIn", new Object[0]), Utils.formatExecutionTime(time));
    }
}

