/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticFuncStart;
import com.intellij.javascript.trace.execution.code.StaticProgramStart;
import com.intellij.javascript.trace.execution.common.FunctionNamePresentation;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.DependencyEventTreeNode;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.FileTreeNode;
import com.intellij.javascript.trace.execution.fileDependency.FunctionCombination;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FunctionTreeNode
extends SimpleNode {
    private final SimpleNode[] myChildren;
    private final String myFuncElementId;
    private final TraceContext myContext;
    private final FileNode myFile;
    private StaticCodeElement myCodeElement;

    public FunctionTreeNode(@NotNull TraceContext context, @NotNull String streamId, @NotNull FileTreeNode parent, @NotNull FunctionCombination functionCombination) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        if (functionCombination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCombination", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        super((SimpleNode)parent);
        this.myContext = context;
        this.myChildren = new SimpleNode[]{new FunctionTreeNode(context, streamId, this, functionCombination)};
        this.myFuncElementId = functionCombination.getFromFunctionId();
        this.myFile = functionCombination.getSourceFile();
        this.init();
    }

    public FunctionTreeNode(final @NotNull TraceContext context, final @NotNull String streamId, @NotNull FunctionTreeNode parent, @NotNull FunctionCombination functionCombination) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        if (functionCombination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCombination", "com/intellij/javascript/trace/execution/fileDependency/FunctionTreeNode", "<init>"));
        }
        super((SimpleNode)parent);
        this.myContext = context;
        ArrayList nodes = new ArrayList();
        nodes.addAll(ContainerUtil.map(functionCombination.getEventHits().entrySet(), (Function)new Function<Map.Entry<Long, Long>, SimpleNode>(){

            public SimpleNode fun(Map.Entry<Long, Long> entry) {
                return new DependencyEventTreeNode(context, FunctionTreeNode.this, streamId, entry.getKey(), entry.getValue());
            }
        }));
        this.myChildren = nodes.toArray(new SimpleNode[nodes.size()]);
        this.myFuncElementId = functionCombination.getToFunctionId();
        this.myFile = functionCombination.getTargetFile();
        this.init();
    }

    private void init() {
        this.myCodeElement = this.myContext.getTraceSession().getCodeElementById(this.myFuncElementId);
        assert (this.myCodeElement != null);
        PresentationData presentation = this.getPresentation();
        this.setIcon(this.myFile.getFileIcon());
        FunctionNamePresentation functionNamePresentation = new FunctionNamePresentation(this.myCodeElement, this.myCodeElement instanceof StaticProgramStart, false);
        presentation.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        functionNamePresentation.buildFullName(presentation, false, null, false);
    }

    public SimpleNode[] getChildren() {
        return this.myChildren;
    }

    public String getFile() {
        return this.myCodeElement.getFile();
    }

    public int getFunctionId() {
        return this.myCodeElement instanceof StaticProgramStart ? ((StaticProgramStart)this.myCodeElement).getFuncId() : ((StaticFuncStart)this.myCodeElement).getFuncId();
    }
}

