/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTreeSearch;
import com.intellij.javascript.trace.execution.stack.StackTreeStructure;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackTree
extends SimpleTree
implements Disposable {
    private final SimpleTreeBuilder myStackTreeBuilder;
    private List<Consumer<StackNode>> myHandlers;
    private List<Consumer<StackNode>> mySelectNodeHandlers;
    private List<Consumer<StackNode>> myCallerHandlers;
    private List<Consumer<StackNode>> mySourceRequestedHandlers;
    private List<Consumer<StackNode>> myMappedTraceRequestedHandlers;
    private StackTreeStructure myStructure;
    private TraceContext myTraceContext;

    public StackTree(@NotNull StackTreeStructure structure, @NotNull TraceContext traceContext) {
        if (structure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/javascript/trace/execution/stack/StackTree", "<init>"));
        }
        if (traceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceContext", "com/intellij/javascript/trace/execution/stack/StackTree", "<init>"));
        }
        this.myHandlers = new ArrayList<Consumer<StackNode>>();
        this.mySelectNodeHandlers = new ArrayList<Consumer<StackNode>>();
        this.myCallerHandlers = new ArrayList<Consumer<StackNode>>();
        this.mySourceRequestedHandlers = new ArrayList<Consumer<StackNode>>();
        this.myMappedTraceRequestedHandlers = new ArrayList<Consumer<StackNode>>();
        this.myStructure = structure;
        this.myTraceContext = traceContext;
        this.getEmptyText().setText("");
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        final ActionManager actionManager = ActionManager.getInstance();
        this.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group = (ActionGroup)actionManager.getAction("Spy-js.Stack.Tree");
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x, y);
            }
        });
        this.myStackTreeBuilder = new SimpleTreeBuilder((JTree)((Object)this), this.getBuilderModel(), (AbstractTreeStructure)structure, null);
        this.myStackTreeBuilder.initRootNode();
        this.myStackTreeBuilder.updateFromRoot();
        this.putClientProperty(IdeTooltip.TOOLTIP_DISMISS_DELAY_KEY, 60000);
        new StackTreeSearch(this, structure, this.myStackTreeBuilder);
    }

    protected void configureUiHelper(TreeUIHelper helper) {
    }

    public void setSelected(@Nullable StackNode stackNode) {
        if (stackNode == null) {
            return;
        }
        this.setSelectedNode((AbstractTreeBuilder)this.myStackTreeBuilder, stackNode, false);
    }

    public boolean isRootNode(StackNode node) {
        return node.getParent().equals(this.myStackTreeBuilder.getRootElement());
    }

    public void stackNodeTraceRequested(StackNode node) {
        for (Consumer<StackNode> handler : this.myHandlers) {
            handler.consume((Object)node);
        }
    }

    public void stackNodeSelected(StackNode node) {
        for (Consumer<StackNode> handler : this.mySelectNodeHandlers) {
            handler.consume((Object)node);
        }
    }

    public void stackNodeCallerTraceRequested(StackNode node) {
        for (Consumer<StackNode> handler : this.myCallerHandlers) {
            handler.consume((Object)node);
        }
    }

    public void addStackNodeTraceRequestHandler(Consumer<StackNode> requestHandler) {
        this.myHandlers.add(requestHandler);
    }

    public void addStackNodeSelectedHandler(Consumer<StackNode> selectHandler) {
        this.mySelectNodeHandlers.add(selectHandler);
    }

    public void addStackNodeCallerTraceRequestHandler(Consumer<StackNode> requestHandler) {
        this.myCallerHandlers.add(requestHandler);
    }

    public void stackNodeSourceRequested(StackNode node) {
        for (Consumer<StackNode> handler : this.mySourceRequestedHandlers) {
            handler.consume((Object)node);
        }
    }

    public void stackNodeMappedTraceRequested(StackNode node) {
        for (Consumer<StackNode> handler : this.myMappedTraceRequestedHandlers) {
            handler.consume((Object)node);
        }
    }

    public void addSourceRequestedHandler(Consumer<StackNode> selectionHandler) {
        this.mySourceRequestedHandlers.add(selectionHandler);
    }

    public void addStackNodeMappedTraceRequestedHandler(Consumer<StackNode> selectionHandler) {
        this.myMappedTraceRequestedHandlers.add(selectionHandler);
    }

    public void processKeyEvent(final KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 10 && !this.isSelectionEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    StackTree.this.getNodeFor(StackTree.this.getSelectionPath()).handleDoubleClickOrEnter((SimpleTree)StackTree.this, (InputEvent)e);
                }
            };
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.stateForComponent((Component)((Object)this)));
            e.consume();
        } else {
            super.processKeyEvent(e);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myStackTreeBuilder);
    }

    @NotNull
    public TraceSettingsManager getTraceSettingsManager() {
        TraceSettingsManager traceSettingsManager = this.myTraceContext.getTraceSettingsManager();
        if (traceSettingsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/stack/StackTree", "getTraceSettingsManager"));
        }
        return traceSettingsManager;
    }

    @NotNull
    public StackNode[] getAllNodes() {
        StackNode[] stackNodeArray = this.myStructure.getAllNodes();
        if (stackNodeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/stack/StackTree", "getAllNodes"));
        }
        return stackNodeArray;
    }

    @NotNull
    public TraceContext getTraceContext() {
        TraceContext traceContext = this.myTraceContext;
        if (traceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/stack/StackTree", "getTraceContext"));
        }
        return traceContext;
    }
}

