/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.stack.actions;

import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Alarm;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StackTreeAction
extends AnAction {
    private TraceContext myContext;
    private final Alarm myAlarm;

    public StackTreeAction(@NotNull TraceContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/stack/actions/StackTreeAction", "<init>"));
        }
        this.myAlarm = new Alarm();
        this.myContext = context;
    }

    public StackTreeAction() {
        this.myAlarm = new Alarm();
    }

    public final void update(final AnActionEvent e) {
        this.myAlarm.cancelAllRequests();
        StackTree tree = this.getTree(e);
        if (tree == null) {
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!(StackTreeAction.this.getTree(e) != null || StackTreeAction.this.myContext != null && StackTreeAction.this.myContext.isLoadingStackTrace())) {
                            e.getPresentation().setEnabledAndVisible(false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, 200);
            return;
        }
        SimpleNode selectedNode = tree.getNodeFor(tree.getSelectionPath());
        if (selectedNode == null || !(selectedNode instanceof StackNode)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (tree.getTraceSettingsManager().isLoaded() && !this.isAvailableForLoadedTrace()) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            this.doUpdate(e, tree, (StackNode)selectedNode);
        }
    }

    public final void actionPerformed(AnActionEvent e) {
        StackTree tree = this.getTree(e);
        if (tree == null) {
            return;
        }
        SimpleNode selectedNode = tree.getNodeFor(tree.getSelectionPath());
        if (selectedNode == null || !(selectedNode instanceof StackNode)) {
            return;
        }
        this.doPerform(e, tree, (StackNode)selectedNode);
    }

    @Nullable
    private StackTree getTree(AnActionEvent e) {
        if (this.myContext == null) {
            Component component = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            if (!(component instanceof StackTree)) {
                return null;
            }
            return (StackTree)((Object)component);
        }
        return this.myContext.getCurrentStackTree();
    }

    protected void doUpdate(AnActionEvent e, @NotNull StackTree tree, @NotNull StackNode selectedNode) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/stack/actions/StackTreeAction", "doUpdate"));
        }
        if (selectedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNode", "com/intellij/javascript/trace/execution/stack/actions/StackTreeAction", "doUpdate"));
        }
    }

    protected abstract void doPerform(AnActionEvent var1, @NotNull StackTree var2, @NotNull StackNode var3);

    protected boolean isAvailableForLoadedTrace() {
        return true;
    }
}

