/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.systemProxy;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.javascript.trace.execution.systemProxy.ProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.ProxySettings;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class LinuxProxyConfigurator
extends ProxyConfigurator {
    private static final Logger LOG = Logger.getInstance(LinuxProxyConfigurator.class);

    @Override
    @NotNull
    protected ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings newSettings) throws ExecutionException {
        String proxyData;
        if (newSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSettings", "com/intellij/javascript/trace/execution/systemProxy/LinuxProxyConfigurator", "updateSettingsReturnExisting"));
        }
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"sh", this.getScriptPath("proxy-nix.sh"), "-autom", newSettings.isTempSettings() ? "auto" : newSettings.getData(), "-autou", newSettings.getAutoConfigUrl() != null && !newSettings.getAutoConfigUrl().isEmpty() ? newSettings.getAutoConfigUrl() : "''"}));
        String error = output.getStderr();
        if (!error.isEmpty()) {
            LOG.warn(error);
        }
        if (!(proxyData = output.getStdout()).isEmpty()) {
            String[] values = proxyData.split(";");
            if (values.length == 2) {
                String mode = values[0] != null ? values[0] : null;
                String url = values[1] != null ? values[1] : null;
                ProxySettings settings = new ProxySettings(false, false, url, "");
                settings.setData(mode);
                ProxySettings proxySettings = settings;
                if (proxySettings == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/systemProxy/LinuxProxyConfigurator", "updateSettingsReturnExisting"));
                }
                return proxySettings;
            }
        } else {
            LOG.warn("Proxy data does not have expected format: " + proxyData);
        }
        ProxySettings proxySettings = new ProxySettings(false, false, null, null);
        if (proxySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/systemProxy/LinuxProxyConfigurator", "updateSettingsReturnExisting"));
        }
        return proxySettings;
    }
}

