/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.settings;

import com.intellij.execution.RunManager;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.settings.EventFilterPanel;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private Project myProject;
    private TraceSettingsManager myTraceSettingsManager;
    private TraceProjectSettings.EventFilterState myActiveEventFilter;
    private final JPanel myFilterDetailsContainer;
    private CheckBoxList<TraceProjectSettings.EventFilterState> myFiltersList;
    private TraceProjectSettings.TraceSettingsState myCurrentState;
    private EventFilterPanel myEventFilterPanel;

    public TraceConfigurable(@NotNull Project project, @NotNull TraceSettingsManager traceSettingsManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/settings/TraceConfigurable", "<init>"));
        }
        if (traceSettingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceSettingsManager", "com/intellij/javascript/trace/settings/TraceConfigurable", "<init>"));
        }
        this.myFilterDetailsContainer = new JPanel(new BorderLayout());
        this.myProject = project;
        this.myTraceSettingsManager = traceSettingsManager;
    }

    @NotNull
    public String getId() {
        String string = TraceBundle.message("settings.id", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/settings/TraceConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return TraceBundle.message("settings.name", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent(this.createFiltersPanel());
        splitter.setSecondComponent((JComponent)this.myFilterDetailsContainer);
        mainPanel.add((Component)splitter, "Center");
        mainPanel.setPreferredSize(new Dimension(600, 350));
        return mainPanel;
    }

    public void addActiveFilterWithCondition(final @NotNull TraceProjectSettings.EventFilterConditionState condition, final @NotNull String nameSuggestion) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/javascript/trace/settings/TraceConfigurable", "addActiveFilterWithCondition"));
        }
        if (nameSuggestion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameSuggestion", "com/intellij/javascript/trace/settings/TraceConfigurable", "addActiveFilterWithCondition"));
        }
        this.addFilter(new Consumer<TraceProjectSettings.EventFilterState>(){

            public void consume(TraceProjectSettings.EventFilterState filter) {
                filter.addEventFilterCondition(condition);
                filter.setName(nameSuggestion);
                TraceConfigurable.this.myActiveEventFilter = filter;
            }
        });
    }

    private JComponent createFiltersPanel() {
        this.myFiltersList = new CheckBoxList((DefaultListModel)new MyFilterListModel(), new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                TraceProjectSettings.EventFilterState filter = (TraceProjectSettings.EventFilterState)TraceConfigurable.this.myFiltersList.getItemAt(index);
                if (filter == null) {
                    return;
                }
                filter.setActive(value);
            }
        });
        this.myFiltersList.setSelectionMode(0);
        this.myFiltersList.setBorder(null);
        this.myFiltersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TraceConfigurable.this.myFilterDetailsContainer.removeAll();
                TraceProjectSettings.EventFilterState selectedValue = TraceConfigurable.this.getSelectedFilter();
                if (selectedValue != null) {
                    TraceConfigurable.this.updateFilterDetails(selectedValue);
                    TraceConfigurable.this.myFiltersList.repaint();
                } else {
                    TraceConfigurable.this.addDescriptionLabel();
                }
                TraceConfigurable.this.myFilterDetailsContainer.revalidate();
            }
        });
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myFiltersList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TraceConfigurable.this.addFilter((Consumer<TraceProjectSettings.EventFilterState>)null);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TraceConfigurable.this.removeFilter();
            }
        }).addExtraAction(new AnActionButton(TraceBundle.message("settings.eventFilters.copy", new Object[0]), TraceBundle.message("settings.eventFilters.copy", new Object[0]), AllIcons.Actions.Copy){

            public void actionPerformed(AnActionEvent e) {
                TraceConfigurable.this.copySelectedFilter();
            }

            public void updateButton(AnActionEvent e) {
                super.updateButton(e);
                if (e.getPresentation().isEnabled() && TraceConfigurable.this.getSelectedFilter() == null) {
                    e.getPresentation().setEnabled(false);
                }
            }
        }).disableUpDownActions();
        return toolbarDecorator.createPanel();
    }

    private TraceProjectSettings.EventFilterState getSelectedFilter() {
        int index = this.myFiltersList.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return (TraceProjectSettings.EventFilterState)this.myFiltersList.getItemAt(index);
    }

    private void copySelectedFilter() {
        TraceProjectSettings.EventFilterState filter = this.getSelectedFilter();
        if (filter == null) {
            return;
        }
        TraceProjectSettings.EventFilterState newFilter = (TraceProjectSettings.EventFilterState)filter.clone();
        newFilter.setName(RunManager.suggestUniqueName((String)newFilter.getName(), this.getCurrentNames()));
        this.doAddFilter(newFilter);
    }

    private void removeFilter() {
        this.myCurrentState.removeEventFilter(this.getSelectedFilter());
        ListUtil.removeSelectedItems(this.myFiltersList);
        this.myFiltersList.repaint();
    }

    private ArrayList<String> getCurrentNames() {
        return new ArrayList<String>(ContainerUtil.map(this.myCurrentState.getEventFilters(), (Function)new Function<TraceProjectSettings.EventFilterState, String>(){

            public String fun(TraceProjectSettings.EventFilterState filter) {
                return filter.getName();
            }
        }));
    }

    private void addFilter(@Nullable Consumer<TraceProjectSettings.EventFilterState> initializer) {
        TraceProjectSettings.EventFilterState filter = new TraceProjectSettings.EventFilterState(RunManager.suggestUniqueName((String)TraceBundle.message("settings.eventFilters.noName", new Object[0]), this.getCurrentNames()), true);
        if (initializer != null) {
            initializer.consume((Object)filter);
        }
        this.doAddFilter(filter);
    }

    private void correctNames() {
        HashSet names = new HashSet();
        List<TraceProjectSettings.EventFilterState> currentFilters = this.myCurrentState.getEventFilters();
        for (int i = 0; i < currentFilters.size(); ++i) {
            String name;
            TraceProjectSettings.EventFilterState currentFilter = currentFilters.get(i);
            String currentName = currentFilter.getName();
            if (currentName.isEmpty()) {
                name = RunManager.suggestUniqueName((String)TraceBundle.message("settings.eventFilters.noName", new Object[0]), new ArrayList(names));
                this.updateFilter(i, name);
                currentFilter.setName(name);
            }
            if (names.contains((Object)currentName)) {
                name = RunManager.suggestUniqueName((String)currentName, new ArrayList(names));
                currentFilter.setName(name);
                this.updateFilter(i, name);
            }
            names.add((Object)currentFilter.getName());
        }
    }

    private void doAddFilter(TraceProjectSettings.EventFilterState filter) {
        this.myCurrentState.addEventFilter(filter);
        this.myFiltersList.addItem((Object)filter, filter.getName(), filter.isActive());
        this.myFiltersList.clearSelection();
        this.correctNames();
        this.selectLastFilter();
    }

    private void selectLastFilter() {
        ScrollingUtil.selectItem(this.myFiltersList, (int)(this.myFiltersList.getModel().getSize() - 1));
    }

    public boolean isModified() {
        return !TraceProjectSettings.getInstance(this.myProject).getState().equals(this.myCurrentState);
    }

    public void apply() throws ConfigurationException {
        TraceProjectSettings.TraceSettingsState storedState = TraceProjectSettings.getInstance(this.myProject).getState();
        boolean activeFilterStillExists = false;
        this.correctNames();
        ArrayList<TraceProjectSettings.EventFilterState> filters = new ArrayList<TraceProjectSettings.EventFilterState>();
        List<TraceProjectSettings.EventFilterState> currentFilters = this.myCurrentState.getEventFilters();
        for (TraceProjectSettings.EventFilterState filter : currentFilters) {
            if (filter.equals(this.myActiveEventFilter) && filter.isActive()) {
                activeFilterStillExists = true;
            }
            filters.add((TraceProjectSettings.EventFilterState)filter.clone());
        }
        storedState.setEventFilters(filters);
        if (TraceProjectSettings.EventFilterState.NULL_FILTER.equals(this.myActiveEventFilter) || !activeFilterStillExists) {
            this.myTraceSettingsManager.setAndApplyFilter(null);
        } else if (!this.myActiveEventFilter.getName().equals(this.myTraceSettingsManager.getActiveFilterName())) {
            this.myTraceSettingsManager.setAndApplyFilter(this.myActiveEventFilter.getName());
        } else {
            this.myTraceSettingsManager.applySettings();
        }
        this.myActiveEventFilter = this.myTraceSettingsManager.getActiveFilter();
        this.myEventFilterPanel.updateNameLabel();
    }

    public void reset() {
        this.myFiltersList.clear();
        this.myCurrentState = (TraceProjectSettings.TraceSettingsState)TraceProjectSettings.getInstance(this.myProject).getState().clone();
        int index = 0;
        int filterIndex = 0;
        for (TraceProjectSettings.EventFilterState filter : this.myCurrentState.getEventFilters()) {
            this.myFiltersList.addItem((Object)filter, filter.getName(), filter.isActive());
            if (filter.getName().equals(this.myTraceSettingsManager.getActiveFilterName())) {
                this.myActiveEventFilter = filter;
                filterIndex = index;
                continue;
            }
            ++index;
        }
        final int activeFilterIndex = filterIndex;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TraceConfigurable.this.myFiltersList.getModel().getSize() > 0) {
                    TraceConfigurable.this.myFiltersList.setSelectedIndex(activeFilterIndex);
                } else {
                    TraceConfigurable.this.addDescriptionLabel();
                }
            }
        });
    }

    public void disposeUIResources() {
    }

    private void addDescriptionLabel() {
        JLabel descLabel = new JLabel(TraceBundle.message("settings.eventFilters.desc", new Object[0]));
        descLabel.setBorder(new EmptyBorder(0, 25, 0, 25));
        this.myFilterDetailsContainer.add((Component)descLabel, "Center");
    }

    private void updateFilterDetails(TraceProjectSettings.EventFilterState filter) {
        final int index = this.myFiltersList.getSelectedIndex();
        this.myEventFilterPanel = new EventFilterPanel(filter, new Consumer<String>(){

            public void consume(String name) {
                if (TraceConfigurable.this.myFiltersList.isEmpty()) {
                    return;
                }
                TraceConfigurable.this.updateFilter(index, name);
            }
        });
        this.myFilterDetailsContainer.add((Component)this.myEventFilterPanel, "Center");
    }

    private void updateFilter(int index, String name) {
        TraceProjectSettings.EventFilterState filter = (TraceProjectSettings.EventFilterState)this.myFiltersList.getItemAt(index);
        if (filter == null) {
            return;
        }
        filter.setName(name);
        ((MyFilterListModel)this.myFiltersList.getModel()).update(index, name);
    }

    private static class MyFilterListModel
    extends DefaultListModel {
        private MyFilterListModel() {
        }

        public void update(int index, String name) {
            Object checkbox = this.getElementAt(index);
            if (checkbox instanceof JCheckBox) {
                ((JCheckBox)checkbox).setText(name);
            }
            this.fireContentsChanged(this, index, index);
        }
    }
}

