/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.StylusUtil;
import org.jetbrains.plugins.stylus.psi.impl.StylusMixinImpl;
import org.jetbrains.plugins.stylus.psi.stubs.StylusMixinIndex;

public class StylusMixinCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        CssSelector[] selectors;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/stylus/completion/StylusMixinCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/stylus/completion/StylusMixinCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        CssSelectorList cssSelectorList = (CssSelectorList)PsiTreeUtil.getParentOfType((PsiElement)position, CssSelectorList.class);
        if (cssSelectorList != null && (selectors = cssSelectorList.getSelectors()).length == 1) {
            GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
            StylusMixinCompletionProvider.addCompletions(result, scope, project);
        }
    }

    private static void addCompletions(final @NotNull CompletionResultSet result, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/stylus/completion/StylusMixinCompletionProvider", "addCompletions"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/stylus/completion/StylusMixinCompletionProvider", "addCompletions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/stylus/completion/StylusMixinCompletionProvider", "addCompletions"));
        }
        for (String name : StubIndex.getInstance().getAllKeys(StylusMixinIndex.KEY, project)) {
            if (name.isEmpty()) continue;
            StylusMixinIndex.process(name, project, scope, (Processor<? super StylusMixinImpl>)new Processor<StylusMixinImpl>(){

                public boolean process(StylusMixinImpl mixin) {
                    result.addElement(StylusUtil.createMixinLookupItem(mixin, true));
                    return true;
                }
            });
        }
    }
}

