/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.jsf.composite.CompositeNamespaceDescriptor;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.facelets.FaceletsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.xml.XmlNSDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeComponentNamespaceDescriptorProvider
implements ImplicitNamespaceDescriptorProvider {
    @Nullable
    public XmlNSDescriptor getNamespaceDescriptor(@Nullable Module module, @NotNull String namespace, PsiFile file) {
        Map<String, String> map;
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/jsf/composite/CompositeComponentNamespaceDescriptorProvider", "getNamespaceDescriptor"));
        }
        for (String compositeNamespace : CompositeUtil.COMPOSITE_NAMESPACES) {
            if (!namespace.startsWith(compositeNamespace + "/")) continue;
            String resourcePath = namespace.substring((compositeNamespace + "/").length());
            return new CompositeNamespaceDescriptor(namespace, resourcePath);
        }
        if (module != null && !DumbService.getInstance((Project)module.getProject()).isDumb() && FaceletsManager.isFaceletFile(file) && (map = CompositeUtil.getFaceletTaglibNamespacesMap(module)).containsKey(namespace)) {
            return new CompositeNamespaceDescriptor(namespace, map.get(namespace));
        }
        return null;
    }
}

