/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite.references;

import com.intellij.jsf.references.JsfResourceIdentifierReferenceSet;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class CompositeURIReferenceProvider
extends PsiReferenceProvider {
    public static final ElementFilter ELEMENT_FILTER = new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement parent = context.getParent();
            if (parent instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)parent;
                String value = attribute.getValue();
                return attribute.isNamespaceDeclaration() && value != null && (value.startsWith("http://java.sun.com/jsf/composite/") || value.startsWith("http://xmlns.jcp.org/jsf/composite/"));
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/composite/references/CompositeURIReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/composite/references/CompositeURIReferenceProvider", "getReferencesByElement"));
        }
        String text = element.getText();
        String s = StringUtil.unquoteString((String)text);
        String compositeNamespace = s.contains("http://java.sun.com/jsf/composite") ? "http://java.sun.com/jsf/composite" : "http://xmlns.jcp.org/jsf/composite";
        int offset = (compositeNamespace + "/").length();
        Object[] psiReferences = new JsfResourceIdentifierReferenceSet(element, s.substring(offset), '/', offset + 1).getPsiReferences();
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])psiReferences, (Object)CompositeURIReferenceProvider.getCompositeNamespaceURIReference(element, compositeNamespace));
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/references/CompositeURIReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static URLReference getCompositeNamespaceURIReference(PsiElement element, String compositeNamespace) {
        return new URLReference(element, TextRange.from((int)1, (int)compositeNamespace.length()), false);
    }
}

