/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.el;

import com.intellij.jsf.el.ELVariableProcessingContext;
import com.intellij.jsf.el.contibutors.CompositeImplementationsELTagContributor;
import com.intellij.jsf.el.contibutors.CustomJsfContextBeansContributor;
import com.intellij.jsf.el.contibutors.CustomVariableResolversContributor;
import com.intellij.jsf.el.contibutors.FacesConfigsContributor;
import com.intellij.jsf.el.contibutors.JsfElVariablesContributor;
import com.intellij.jsf.el.contibutors.PredefinedVariablesContributor;
import com.intellij.jsf.el.contibutors.ResourceBundleContributor;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspManagerImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfElVariablesProvider
extends ElVariablesProvider {
    private static JsfElVariablesContributor[] ourMyContributors = new JsfElVariablesContributor[]{new FacesConfigsContributor(), new PredefinedVariablesContributor(), new CustomJsfContextBeansContributor(), new ResourceBundleContributor(), new CustomVariableResolversContributor(), new CompositeImplementationsELTagContributor()};
    private static final NotNullFunction<XmlTag, String> DEFAULT_JSF_VAR_TYPE_PROVIDER = new NotNullFunction<XmlTag, String>(){

        @NotNull
        public String fun(XmlTag tag) {
            if ("loadBundle".equals(tag.getLocalName()) && Arrays.asList(XmlUtil.JSF_CORE_URIS).contains(tag.getNamespace())) {
                if ("java.util.PropertyResourceBundle" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/el/JsfElVariablesProvider$1", "fun"));
                }
                return "java.util.PropertyResourceBundle";
            }
            if ("java.util.Map" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/el/JsfElVariablesProvider$1", "fun"));
            }
            return "java.util.Map";
        }
    };

    public boolean processImplicitVariables(@NotNull PsiElement element, @NotNull ELExpressionHolder expressionHolder, @NotNull ELElementProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/el/JsfElVariablesProvider", "processImplicitVariables"));
        }
        if (expressionHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionHolder", "com/intellij/jsf/el/JsfElVariablesProvider", "processImplicitVariables"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jsf/el/JsfElVariablesProvider", "processImplicitVariables"));
        }
        PsiFile containingFile = expressionHolder.getContainingFile();
        if (expressionHolder.isJSFELHolder() || JspManager.getInstance((Project)containingFile.getProject()).getJspVersion((PsiFileSystemItem)containingFile).betterThan(JspVersion.JSP_2_0) && JsfElVariablesProvider.hasJsfNsDefinedIn(containingFile)) {
            VirtualFile file = containingFile.getOriginalFile().getVirtualFile();
            XmlTag tag = ELResolveUtil.getParentTagToStartResolving((PsiElement)element, (ELExpressionHolder)expressionHolder);
            if (tag != null && !ELResolveUtil.walkFromContext((XmlTag)tag, (ELElementProcessor)processor, DEFAULT_JSF_VAR_TYPE_PROVIDER, (PsiElement)expressionHolder)) {
                return false;
            }
            if (file == null) {
                return true;
            }
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return true;
            }
            ELVariableProcessingContext context = ELVariableProcessingContext.create(module, containingFile, element, expressionHolder);
            for (JsfElVariablesContributor variablesContributor : ourMyContributors) {
                for (PsiVariable implicitVariable : this.getOrCreateVariables(variablesContributor, context)) {
                    if (processor.processVariable(implicitVariable)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public List<PsiVariable> getOrCreateVariables(@NotNull JsfElVariablesContributor contributor, @NotNull ELVariableProcessingContext context) {
        CachedValueProvider valueProvider;
        if (contributor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributor", "com/intellij/jsf/el/JsfElVariablesProvider", "getOrCreateVariables"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/el/JsfElVariablesProvider", "getOrCreateVariables"));
        }
        PsiFile file = context.getContainingFile();
        Key<CachedValue<List<PsiVariable>>> valueKey = contributor.getKey();
        if (valueKey == null) {
            List<PsiVariable> list = contributor.getVariables(context);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/el/JsfElVariablesProvider", "getOrCreateVariables"));
            }
            return list;
        }
        CachedValue cachedVars = (CachedValue)file.getUserData(valueKey);
        if (cachedVars == null) {
            PsiManager manager = file.getManager();
            cachedVars = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue((CachedValueProvider)new MyCachedValueProvider(contributor), false);
            file.putUserData(valueKey, (Object)cachedVars);
        }
        if ((valueProvider = cachedVars.getValueProvider()) instanceof MyCachedValueProvider) {
            ((MyCachedValueProvider)valueProvider).setContext(context);
        }
        List list = (List)cachedVars.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/el/JsfElVariablesProvider", "getOrCreateVariables"));
        }
        return list;
    }

    private Object[] getDependencies(Project project) {
        return new Object[]{JspManagerImpl.getInstance((Project)project).getRootsModificationTracker(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};
    }

    private static boolean hasJsfNsDefinedIn(PsiFile containingFile) {
        XmlTag rootTag;
        XmlDocument document;
        if (containingFile instanceof JspFile && (document = ((JspFile)containingFile).getDocument()) != null && (rootTag = document.getRootTag()) != null) {
            for (String coreUri : XmlUtil.JSF_CORE_URIS) {
                String prefix = rootTag.getPrefixByNamespace(coreUri);
                if (prefix == null || prefix.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private class MyCachedValueProvider
    implements CachedValueProvider<List<PsiVariable>> {
        private JsfElVariablesContributor myContributor;
        private ELVariableProcessingContext myContext = null;

        public MyCachedValueProvider(JsfElVariablesContributor contributor) {
            this.myContributor = contributor;
        }

        public CachedValueProvider.Result<List<PsiVariable>> compute() {
            ArrayList<PsiVariable> result = new ArrayList<PsiVariable>(3);
            if (this.getContext() != null) {
                result.addAll(this.myContributor.getVariables(this.getContext()));
            }
            return new CachedValueProvider.Result(result, JsfElVariablesProvider.this.getDependencies(this.myContext.getModule().getProject()));
        }

        public void setContext(ELVariableProcessingContext context) {
            this.myContext = context;
        }

        @Nullable
        private ELVariableProcessingContext getContext() {
            return this.myContext;
        }
    }
}

