/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.html5;

import com.intellij.jsf.html5.tagDecorators.TagDecoratorManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PassThroughAttrDescriptorProvider
implements XmlAttributeDescriptorsProvider {
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag context) {
        XmlElementDescriptor decoratedTag;
        XmlElementDescriptor descriptor;
        String prefixByNamespace;
        HashSet descriptors = new HashSet();
        if (HtmlUtil.isHtml5Context((XmlElement)context) && (prefixByNamespace = context.getPrefixByNamespace("http://xmlns.jcp.org/jsf")) != null && (descriptor = context.getDescriptor()) != null && (decoratedTag = TagDecoratorManager.decorate(context)) != null) {
            XmlAttributeDescriptor[] attributesDescriptors;
            for (XmlAttributeDescriptor attributesDescriptor : attributesDescriptors = decoratedTag.getAttributesDescriptors(context)) {
                descriptors.add(new AnyXmlAttributeDescriptor(prefixByNamespace + ":" + attributesDescriptor.getName()));
            }
            descriptors.addAll(Arrays.asList(attributesDescriptors));
        }
        return descriptors.toArray(new XmlAttributeDescriptor[descriptors.size()]);
    }

    @NotNull
    private static XmlAttributeDescriptor[] getOwnAttributeDescriptors(@NotNull XmlTag context, final @NotNull XmlElementDescriptor descriptor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/html5/PassThroughAttrDescriptorProvider", "getOwnAttributeDescriptors"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jsf/html5/PassThroughAttrDescriptorProvider", "getOwnAttributeDescriptors"));
        }
        XmlAttributeDescriptor[] descriptors = (XmlAttributeDescriptor[])RecursionManager.doPreventingRecursion((Object)context, (boolean)true, (Computable)new Computable<XmlAttributeDescriptor[]>(){

            public XmlAttributeDescriptor[] compute() {
                return descriptor.getAttributesDescriptors(null);
            }
        });
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = descriptors == null ? XmlAttributeDescriptor.EMPTY : descriptors;
        if (xmlAttributeDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/html5/PassThroughAttrDescriptorProvider", "getOwnAttributeDescriptors"));
        }
        return xmlAttributeDescriptorArray;
    }

    @Nullable
    public XmlAttributeDescriptor getAttributeDescriptor(final String attributeName, XmlTag context) {
        String namespaceByPrefix;
        String prefixByQualifiedName = XmlUtil.findPrefixByQualifiedName((String)attributeName);
        if (prefixByQualifiedName.length() != 0 && "http://xmlns.jcp.org/jsf".equals(namespaceByPrefix = context.getNamespaceByPrefix(prefixByQualifiedName))) {
            return new AnyXmlAttributeDescriptor(attributeName){

                public boolean hasIdType() {
                    return "id".equals(XmlUtil.findLocalNameByQualifiedName((String)attributeName));
                }

                public boolean hasIdRefType() {
                    return "for".equals(XmlUtil.findLocalNameByQualifiedName((String)attributeName));
                }
            };
        }
        return null;
    }
}

