/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.jsf.model.common.JsfCommonConverter;
import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.JsfIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfConverterIdXmlAttributeReferencesProvider
extends JsfXmlAttributeReferencesProvider {
    @NonNls
    private static final String CONVERTER_ATTR_NAME = "converter";
    @NonNls
    private static final String CONVERTER_ID_ATTR_NAME = "converterId";

    @Override
    public String[] getAttributeNames() {
        return new String[]{CONVERTER_ATTR_NAME, CONVERTER_ID_ATTR_NAME};
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue element, ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfConverterIdXmlAttributeReferencesProvider", "createReferences"));
        }
        return new PsiReference[]{new BasicAttributeValueReference((PsiElement)element){

            @Nullable
            public PsiElement resolve() {
                String converterId = this.getCanonicalText();
                if (!StringUtil.isEmptyOrSpaces((String)converterId)) {
                    for (JsfCommonConverter converter : JsfCommonUtils.getJsfConverters(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement))) {
                        if (!converterId.equals(converter.getConverterId())) continue;
                        return converter.getIdentifyingElement();
                    }
                }
                return null;
            }

            @NotNull
            public Object[] getVariants() {
                List elements = ContainerUtil.mapNotNull(JsfCommonUtils.getJsfConverters(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement)), (Function)new Function<JsfCommonConverter, LookupElement>(){

                    public LookupElement fun(JsfCommonConverter converter) {
                        PsiElement psiElement = converter.getIdentifyingElement();
                        String converterId = converter.getConverterId();
                        if (StringUtil.isEmptyOrSpaces((String)converterId) || psiElement == null) {
                            return null;
                        }
                        return LookupElementBuilder.create((Object)psiElement, (String)converterId).withIcon(JsfIcons.Converter);
                    }
                });
                Object[] objectArray = ArrayUtil.toObjectArray((Collection)elements);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfConverterIdXmlAttributeReferencesProvider$1", "getVariants"));
                }
                return objectArray;
            }

            public boolean isSoft() {
                return true;
            }
        }};
    }

    @Override
    public ElementFilter getElementFilter() {
        final Set<String> namespaces = JsfCommonUtils.getJsfNamespaces();
        return new ElementFilter(){

            public boolean isAcceptable(Object element, @Nullable PsiElement context) {
                if (context instanceof XmlAttributeValue) {
                    XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
                    return xmlAttribute != null && namespaces.contains(xmlAttribute.getNamespace());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }
}

