/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.libraries;

import com.intellij.jsf.references.libraries.providers.BooleanPsiReferenceProvider;
import com.intellij.jsf.references.libraries.providers.DoubleReferenceProvider;
import com.intellij.jsf.references.libraries.providers.FloatReferenceProvider;
import com.intellij.jsf.references.libraries.providers.IntegerReferenceProvider;
import com.intellij.jsf.references.libraries.providers.JsfWrappingPathReferenceProvider;
import com.intellij.jsf.references.libraries.providers.JsfWrappingPsiClassReferenceProvider;
import com.intellij.jsf.references.libraries.providers.LongReferenceProvider;
import com.intellij.jsf.references.libraries.providers.MultiVariantsPsiReferenceProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfComponentLibraryReferenceProviderRegistry {
    private Map<String, Factory<PsiReferenceProvider>> myReferenceProviders = new HashMap();

    public static JsfComponentLibraryReferenceProviderRegistry getInstance() {
        return (JsfComponentLibraryReferenceProviderRegistry)ServiceManager.getService(JsfComponentLibraryReferenceProviderRegistry.class);
    }

    public JsfComponentLibraryReferenceProviderRegistry() {
        this.initProviders();
    }

    private void initProviders() {
        this.registerReferenceProvider("boolean", new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return BooleanPsiReferenceProvider.getInstance();
            }
        });
        this.registerReferenceProvider("integer", new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return IntegerReferenceProvider.getInstance();
            }
        });
        this.registerReferenceProvider("float", new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return FloatReferenceProvider.getInstance();
            }
        });
        this.registerReferenceProvider("long", new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return LongReferenceProvider.getInstance();
            }
        });
        this.registerReferenceProvider("double", new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return DoubleReferenceProvider.getInstance();
            }
        });
        this.registerReferenceProvider(MultiVariantsPsiReferenceProvider.getProviderName(), new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return new MultiVariantsPsiReferenceProvider();
            }
        });
        this.registerReferenceProvider("styleClass", new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return CssReferenceProviderUtil.CSS_CLASS_OR_ID_KEY_PROVIDER.getProvider();
            }
        });
        this.registerReferenceProvider(JsfWrappingPsiClassReferenceProvider.getProviderName(), new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return new JsfWrappingPsiClassReferenceProvider();
            }
        });
        this.registerReferenceProvider(JsfWrappingPathReferenceProvider.getProviderName(), new Factory<PsiReferenceProvider>(){

            public PsiReferenceProvider create() {
                return new JsfWrappingPathReferenceProvider();
            }
        });
    }

    public void registerReferenceProvider(@NotNull String id, Factory<PsiReferenceProvider> provider) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/jsf/references/libraries/JsfComponentLibraryReferenceProviderRegistry", "registerReferenceProvider"));
        }
        this.myReferenceProviders.put(id, provider);
    }

    @Nullable
    public PsiReferenceProvider getReferenceProvider(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/jsf/references/libraries/JsfComponentLibraryReferenceProviderRegistry", "getReferenceProvider"));
        }
        Factory<PsiReferenceProvider> factory = this.myReferenceProviders.get(id);
        return factory == null ? null : (PsiReferenceProvider)factory.create();
    }
}

