/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.libraries.beans;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReferenceProviderBeanInfo {
    private final String myReferenceProviderId;
    @Nullable
    private final String myUserData;
    public final ElementPattern<XmlTag> tagPattern;

    protected ReferenceProviderBeanInfo(String namespace, String tagName, String referenceProviderId, @Nullable String userData) {
        this.myReferenceProviderId = referenceProviderId;
        this.myUserData = userData;
        this.tagPattern = ((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName(ReferenceProviderBeanInfo.splitDelimitedStrings(tagName))).withNamespace(ReferenceProviderBeanInfo.splitDelimitedStrings(namespace));
    }

    @NotNull
    public String getReferenceProviderId() {
        String string = this.myReferenceProviderId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/beans/ReferenceProviderBeanInfo", "getReferenceProviderId"));
        }
        return string;
    }

    @Nullable
    public String getUserData() {
        return this.myUserData;
    }

    protected static String[] splitDelimitedStrings(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/jsf/references/libraries/beans/ReferenceProviderBeanInfo", "splitDelimitedStrings"));
        }
        List strings = ContainerUtil.mapNotNull((Collection)StringUtil.split((String)s, (String)","), (Function)new Function<String, String>(){

            @Nullable
            public String fun(String s) {
                String trimmed = s.trim();
                return StringUtil.isEmpty((String)trimmed) ? null : trimmed;
            }
        });
        return ArrayUtil.toStringArray((Collection)strings);
    }
}

