/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor;

import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.model.xml.ejb.MessageDrivenBean;
import com.intellij.javaee.model.xml.ejb.SessionBean;
import com.intellij.javaee.oss.jboss.model.JBossCmpBean;
import com.intellij.javaee.oss.jboss.model.JBossCmpRoot;
import com.intellij.javaee.oss.jboss.model.JBossEjbRoot;
import com.intellij.javaee.oss.jboss.model.JBossEntityBean;
import com.intellij.javaee.oss.jboss.model.JBossMessageBean;
import com.intellij.javaee.oss.jboss.model.JBossSessionBean;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;

class JBossEjbUtil {
    private JBossEjbUtil() {
    }

    @Nullable
    static JBossEntityBean findEntityBean(JBossEjbRoot root, final EntityBean source) {
        if (root == null || source == null) {
            return null;
        }
        return (JBossEntityBean)ContainerUtil.find(root.getEnterpriseBeans().getEntityBeans(), (Condition)new Condition<JBossEntityBean>(){

            public boolean value(JBossEntityBean target) {
                return source.equals(target.getEjbName().getValue());
            }
        });
    }

    @Nullable
    static JBossSessionBean findSessionBean(JBossEjbRoot root, final SessionBean source) {
        if (root == null || source == null) {
            return null;
        }
        return (JBossSessionBean)ContainerUtil.find(root.getEnterpriseBeans().getSessionBeans(), (Condition)new Condition<JBossSessionBean>(){

            public boolean value(JBossSessionBean target) {
                return source.equals(target.getEjbName().getValue());
            }
        });
    }

    @Nullable
    static JBossMessageBean findMessageBean(JBossEjbRoot root, final MessageDrivenBean source) {
        if (root == null || source == null) {
            return null;
        }
        return (JBossMessageBean)ContainerUtil.find(root.getEnterpriseBeans().getMessageBeans(), (Condition)new Condition<JBossMessageBean>(){

            public boolean value(JBossMessageBean target) {
                return source.equals(target.getEjbName().getValue());
            }
        });
    }

    @Nullable
    static JBossCmpBean findCmpBean(JBossCmpRoot root, final EntityBean source) {
        if (root == null || source == null) {
            return null;
        }
        return (JBossCmpBean)ContainerUtil.find(root.getEnterpriseBeans().getCmpBeans(), (Condition)new Condition<JBossCmpBean>(){

            public boolean value(JBossCmpBean target) {
                return source.equals(target.getEjbName().getValue());
            }
        });
    }

    static boolean isCmpBean(EntityBean bean) {
        return bean != null && bean.getPersistenceType().getValue() == PersistenceType.CONTAINER;
    }
}

