/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.version;

import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.jboss.version.JBossVersionHandler;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public abstract class JBossVersionHandlerBase
implements JBossVersionHandler {
    private final String myHome;
    private JavaeeServerVersionDescriptor myVersionDescriptor;

    public JBossVersionHandlerBase(String home) {
        this.myHome = home;
    }

    @Override
    public void detect() throws IOException {
        this.myVersionDescriptor = this.doDetect();
    }

    @Override
    public JavaeeServerVersionDescriptor getVersionDescriptor() {
        return this.myVersionDescriptor;
    }

    protected final String getHome() {
        return this.myHome;
    }

    protected final File findFileUnderHome(@NonNls String relativePath) throws IOException {
        File result = new File(this.getHome(), FileUtil.toSystemDependentName((String)relativePath));
        if (!result.exists()) {
            throw new FileNotFoundException(JavaeeBundle.getText((String)"Error.fileNotFound", (Object[])new Object[]{relativePath}));
        }
        return result;
    }

    protected abstract JavaeeServerVersionDescriptor doDetect() throws IOException;
}

