/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLock;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatementImpl;
import com.intellij.psi.impl.source.jsp.jspJava.JspxStaticImportStatement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JspxImportListAttribute {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.jspJava.JspxImportListAttribute");
    private final XmlAttribute myAttribute;
    private final JspxImportList myImportList;
    private volatile List<JspxImportStatementImpl> myImports;
    private volatile List<JspxStaticImportStatement> myStaticImports;
    private volatile boolean[] myIsStaticImport;
    private volatile TextRange[] myImportStatementRanges;

    public JspxImportListAttribute(@NotNull XmlAttribute attribute, @NotNull JspxImportList importList) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "<init>"));
        }
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "<init>"));
        }
        this.myAttribute = attribute;
        this.myImportList = importList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    JspxImportStatementImpl[] getImportStatements() {
        List<JspxImportStatementImpl> imports = this.myImports;
        TextRange[] importStatementRanges = this.myImportStatementRanges;
        if (imports == null || importStatementRanges == null) {
            boolean[] staticImport = this.myIsStaticImport;
            if (importStatementRanges == null || staticImport == null) {
                Pair<TextRange[], boolean[]> pair = this.buildRanges();
                importStatementRanges = (TextRange[])pair.getFirst();
                staticImport = (boolean[])pair.getSecond();
            }
            Object object = PsiLock.LOCK;
            synchronized (object) {
                imports = this.myImports;
                if (imports == null) {
                    imports = new ArrayList<JspxImportStatementImpl>(importStatementRanges.length);
                    for (int i = 0; i < importStatementRanges.length; ++i) {
                        boolean isStatic = staticImport[i];
                        if (isStatic) continue;
                        TextRange textRange = importStatementRanges[i];
                        imports.add(new JspxImportStatementImpl(this.myImportList, this, textRange));
                    }
                    this.myImports = imports;
                }
            }
        }
        JspxImportStatementImpl[] jspxImportStatementImplArray = imports.toArray(new JspxImportStatementImpl[imports.size()]);
        if (jspxImportStatementImplArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "getImportStatements"));
        }
        return jspxImportStatementImplArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    JspxStaticImportStatement[] getStaticImportStatements() {
        List<JspxStaticImportStatement> imports = this.myStaticImports;
        TextRange[] importStatementRanges = this.myImportStatementRanges;
        if (imports == null || importStatementRanges == null) {
            boolean[] staticImport = this.myIsStaticImport;
            if (importStatementRanges == null || staticImport == null) {
                Pair<TextRange[], boolean[]> pair = this.buildRanges();
                importStatementRanges = (TextRange[])pair.getFirst();
                staticImport = (boolean[])pair.getSecond();
            }
            Object object = PsiLock.LOCK;
            synchronized (object) {
                imports = this.myStaticImports;
                if (imports == null) {
                    imports = new ArrayList<JspxStaticImportStatement>(importStatementRanges.length);
                    for (int i = 0; i < importStatementRanges.length; ++i) {
                        boolean isStatic = staticImport[i];
                        if (!isStatic) continue;
                        TextRange textRange = importStatementRanges[i];
                        imports.add(new JspxStaticImportStatement(this.myImportList, this, textRange));
                    }
                    this.myStaticImports = imports;
                }
            }
        }
        JspxStaticImportStatement[] jspxStaticImportStatementArray = imports.toArray(new JspxStaticImportStatement[imports.size()]);
        if (jspxStaticImportStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "getStaticImportStatements"));
        }
        return jspxStaticImportStatementArray;
    }

    @NotNull
    private Pair<TextRange[], boolean[]> buildRanges() {
        String importList = this.getAttribute().getValue();
        if (importList == null) {
            this.myImportStatementRanges = new TextRange[0];
            this.myIsStaticImport = new boolean[0];
            Pair pair = Pair.create((Object)new TextRange[0], (Object)new boolean[0]);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "buildRanges"));
            }
            return pair;
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<Boolean> isStatic = new ArrayList<Boolean>();
        int start = 0;
        while (true) {
            TextRange textRange;
            int delim;
            if ((delim = importList.indexOf(44, start)) == -1) {
                delim = importList.length();
            }
            if (delim <= start) break;
            String importString = importList.substring(start, delim);
            String importClass = importString.trim();
            boolean isStaticImport = false;
            int trimOffset = importList.indexOf(importClass, start);
            String staticPrefix = "static ";
            if (importClass.startsWith(staticPrefix)) {
                isStaticImport = true;
            }
            if (!(textRange = new TextRange(trimOffset, trimOffset + importClass.length())).isEmpty()) {
                ranges.add(textRange);
                isStatic.add(isStaticImport);
            }
            start = delim + 1;
        }
        boolean[] booleans = new boolean[isStatic.size()];
        for (int i = 0; i < isStatic.size(); ++i) {
            Boolean isS = (Boolean)isStatic.get(i);
            booleans[i] = isS;
        }
        TextRange[] array = ranges.toArray(new TextRange[ranges.size()]);
        this.myImportStatementRanges = array;
        this.myIsStaticImport = booleans;
        Pair pair = Pair.create((Object)array, (Object)booleans);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "buildRanges"));
        }
        return pair;
    }

    void delete(int index) {
        this.getImportStatements();
        TextRange[] importStatementRanges = this.myImportStatementRanges;
        boolean[] staticImport = this.myIsStaticImport;
        if (importStatementRanges == null || staticImport == null) {
            Pair<TextRange[], boolean[]> pair = this.buildRanges();
            importStatementRanges = (TextRange[])pair.getFirst();
        }
        if (importStatementRanges.length > 1) {
            TextRange textRange = index > 0 ? new TextRange(importStatementRanges[index - 1].getEndOffset(), importStatementRanges[index].getEndOffset()) : new TextRange(0, importStatementRanges[index + 1].getStartOffset());
            this.myImports.remove(index);
            this.replacePartOfAttribute(textRange, "");
        } else {
            try {
                XmlTag parent = this.getAttribute().getParent();
                if (parent.getValue().getTextRange().getLength() == 0 && parent.getAttributes().length == 1) {
                    parent.delete();
                } else {
                    this.myAttribute.delete();
                }
                this.myImportStatementRanges = null;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    void replace(int index, String fqn) {
        this.getImportStatements();
        TextRange importStatementRange = this.myImportStatementRanges[index];
        this.replacePartOfAttribute(importStatementRange, fqn);
    }

    private void replacePartOfAttribute(TextRange importStatementRange, String newValue) {
        try {
            String value = this.getAttribute().getValue();
            assert (value != null);
            this.getAttribute().setValue(value.substring(0, importStatementRange.getStartOffset()) + newValue + value.substring(importStatementRange.getEndOffset()));
            this.myImportStatementRanges = null;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public XmlAttribute getAttribute() {
        return this.myAttribute;
    }

    public TextRange getImportStatementRange(JspxImportStatement statement) {
        this.getImportStatements();
        int index = this.getIndex(statement);
        if (index >= 0) {
            return this.myImportStatementRanges[index];
        }
        return null;
    }

    public int getIndex(JspxImportStatement statement) {
        List<JspxImportStatementImpl> imports = statement instanceof JspxStaticImportStatement ? this.myStaticImports : this.myImports;
        for (int i = 0; i < imports.size(); ++i) {
            JspxImportStatement importStatement = imports.get(i);
            if (importStatement != statement) continue;
            return i;
        }
        return -1;
    }
}

