/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspJava;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportListAttribute;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatementImpl;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CachedValueBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxImportListImpl
extends PsiElementBase
implements JspxImportList {
    private final PsiFile myJavaRoot;
    private final CachedValue<JspxImportListAttribute[]> myImportAttributes;

    public JspxImportListImpl(PsiFile container) {
        this.myJavaRoot = container;
        this.myImportAttributes = this.createImportAttributesCachedValue();
    }

    private CachedValue<JspxImportListAttribute[]> createImportAttributesCachedValue() {
        return CachedValuesManager.getManager((Project)this.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<JspxImportListAttribute[]>(){

            public CachedValueProvider.Result<JspxImportListAttribute[]> compute() {
                JspxImportListAttribute[] attributes = JspxImportListImpl.this.computeAttributes(true);
                return new CachedValueProvider.Result((Object)attributes, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        }, false);
    }

    private JspxImportListAttribute[] computeAttributes(boolean checkIncludes) {
        ArrayList<JspxImportListAttribute> listAttributes = new ArrayList<JspxImportListAttribute>();
        List<XmlTag> allImportDirectives = this.getAllImportDirectives(checkIncludes);
        for (XmlTag xmlTag : allImportDirectives) {
            for (XmlAttribute attribute : xmlTag.getAttributes()) {
                String namespace;
                if (!"import".equals(attribute.getName()) || !(namespace = attribute.getNamespace()).isEmpty() && !"http://java.sun.com/JSP/Page".equals(namespace)) continue;
                listAttributes.add(new JspxImportListAttribute(attribute, this));
            }
        }
        return listAttributes.toArray(new JspxImportListAttribute[listAttributes.size()]);
    }

    private List<XmlTag> getAllImportDirectives(boolean checkIncludes) {
        XmlTag[] directiveTags;
        ArrayList<XmlTag> importStatements = new ArrayList<XmlTag>();
        JspFile jspFile = this.getJspRoot();
        block0: for (XmlTag directiveTag : directiveTags = jspFile.getDirectiveTags(JspDirectiveKind.PAGE, checkIncludes)) {
            for (XmlAttribute attribute : directiveTag.getAttributes()) {
                String namespace;
                if (!"import".equals(attribute.getName()) || !(namespace = attribute.getNamespace()).isEmpty() && !"http://java.sun.com/JSP/Page".equals(namespace)) continue;
                importStatements.add(directiveTag);
                continue block0;
            }
        }
        return importStatements;
    }

    private JspFile getJspRoot() {
        FileViewProvider viewProvider = this.myJavaRoot.getViewProvider();
        return (JspFile)viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @NotNull
    public PsiImportStatement[] getImportStatements() {
        JspxImportListAttribute[] importAttributes = this.getImportAttributes();
        ArrayList importStatements = new ArrayList(importAttributes.length);
        for (JspxImportListAttribute importAttribute : importAttributes) {
            ContainerUtil.addAll(importStatements, (Object[])importAttribute.getImportStatements());
        }
        PsiImportStatement[] psiImportStatementArray = importStatements.isEmpty() ? PsiImportStatement.EMPTY_ARRAY : importStatements.toArray(new PsiImportStatement[importStatements.size()]);
        if (psiImportStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "getImportStatements"));
        }
        return psiImportStatementArray;
    }

    private synchronized JspxImportListAttribute[] getImportAttributes() {
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            ((CachedValueBase)this.myImportAttributes).clear();
            return this.computeAttributes(false);
        }
        return (JspxImportListAttribute[])this.myImportAttributes.getValue();
    }

    @NotNull
    public PsiImportStaticStatement[] getImportStaticStatements() {
        JspxImportListAttribute[] importAttributes;
        ArrayList importStatements = new ArrayList();
        for (JspxImportListAttribute importAttribute : importAttributes = this.getImportAttributes()) {
            ContainerUtil.addAll(importStatements, (Object[])importAttribute.getStaticImportStatements());
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStatements.toArray(new PsiImportStaticStatement[importStatements.size()]);
        if (psiImportStaticStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "getImportStaticStatements"));
        }
        return psiImportStaticStatementArray;
    }

    @NotNull
    public PsiImportStatementBase[] getAllImportStatements() {
        PsiImportStatementBase[] psiImportStatementBaseArray = (PsiImportStatementBase[])ArrayUtil.mergeArrays((Object[])this.getImportStatements(), (Object[])this.getImportStaticStatements(), (ArrayFactory)PsiImportStatementBase.ARRAY_FACTORY);
        if (psiImportStatementBaseArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "getAllImportStatements"));
        }
        return psiImportStatementBaseArray;
    }

    public PsiImportStatement findSingleClassImportStatement(String qName) {
        return this.findImportStatement(qName);
    }

    @Nullable
    private PsiImportStatement findImportStatement(String text) {
        PsiImportStatement[] importStatements;
        for (PsiImportStatement importStatement : importStatements = this.getImportStatements()) {
            if (!text.equals(importStatement.getQualifiedName())) continue;
            return importStatement;
        }
        return null;
    }

    public PsiImportStatement findOnDemandImportStatement(String packageName) {
        return this.findImportStatement(packageName + ".*");
    }

    public PsiImportStatementBase findSingleImportStatement(String name) {
        return this.findImportStatement(name);
    }

    public boolean isReplaceEquivalent(PsiImportList otherList) {
        PsiImportStatement[] importStatements2;
        PsiImportStatement[] importStatements1 = this.getImportStatements();
        if (importStatements1.length != (importStatements2 = otherList.getImportStatements()).length) {
            return false;
        }
        for (int i = 0; i < importStatements1.length; ++i) {
            PsiImportStatement importStatement1 = importStatements1[i];
            PsiImportStatement importStatement2 = importStatements2[i];
            if (Comparing.strEqual((String)importStatement1.getQualifiedName(), (String)importStatement2.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Language getLanguage() {
        Language language = StdLanguages.JSPX;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "getLanguage"));
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myJavaRoot.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiImportStatement[] psiImportStatementArray = this.getImportStatements();
        if (psiImportStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "getChildren"));
        }
        return psiImportStatementArray;
    }

    public PsiElement getParent() {
        return this.myJavaRoot;
    }

    public PsiElement getNextSibling() {
        ASTNode child = this.findThisElementInFileByTree();
        child = child != null ? child.getTreeNext() : null;
        return child != null ? child.getPsi() : null;
    }

    public PsiElement getPrevSibling() {
        ASTNode child = this.findThisElementInFileByTree();
        child = child != null ? child.getTreePrev() : null;
        return child != null ? child.getPsi() : null;
    }

    @Nullable
    private ASTNode findThisElementInFileByTree() {
        ASTNode child;
        for (child = this.myJavaRoot.getNode().getFirstChildNode(); child != null && child.getPsi() != this; child = child.getTreeNext()) {
        }
        return child;
    }

    public PsiFile getContainingFile() {
        return this.myJavaRoot;
    }

    public TextRange getTextRange() {
        return TextRange.EMPTY_RANGE;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return 0;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public PsiReference findReferenceAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "textToCharArray"));
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "textMatches"));
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "textMatches"));
        }
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportList((PsiImportList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement copy() {
        return new JspxImportListImpl(this.myJavaRoot);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        String qualifiedName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "add"));
        }
        if (!(element instanceof PsiImportStatement) && !(element instanceof PsiImportStaticStatement)) {
            throw new IncorrectOperationException("Cannot add anything but import statements into JSP import list: " + element);
        }
        XmlTag rootTag = this.getJspRoot().getRootTag();
        PsiImportStatementBase importStatement = (PsiImportStatementBase)element;
        boolean isStatic = importStatement instanceof PsiImportStaticStatement;
        if (isStatic) {
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            assert (reference != null);
            qualifiedName = reference.getCanonicalText();
        } else {
            qualifiedName = ((PsiImportStatement)importStatement).getQualifiedName();
        }
        XmlTag lastImportDirective = this.findLastImportDirective();
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)this.getProject()).getCurrentSettings();
        if (codeStyleSettings.JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST && lastImportDirective != null) {
            XmlAttribute attribute = lastImportDirective.getAttribute("import");
            assert (attribute != null);
            attribute.setValue(attribute.getValue() + ", " + qualifiedName + (importStatement.isOnDemand() ? ".*" : ""));
        } else {
            ASTNode anchor = lastImportDirective != null ? lastImportDirective.getNode() : XmlChildRole.START_TAG_END_FINDER.findChild(rootTag.getNode());
            ASTNode parent = anchor == null ? null : TreeUtil.findParent((ASTNode)anchor, (IElementType)XmlElementType.XML_TAG);
            XmlTag directive = this.getJspRoot().createDirective(parent != null ? (XmlTag)parent.getPsi() : null, JspDirectiveKind.PAGE);
            String text = qualifiedName + (importStatement.isOnDemand() ? ".*" : "");
            if (isStatic) {
                text = "static " + text;
            }
            directive.setAttribute("import", text);
            if (anchor != null) {
                anchor.getTreeParent().getPsi().addAfter((PsiElement)directive, anchor.getPsi());
            } else {
                rootTag.add((PsiElement)directive);
            }
        }
        this.clearCaches();
        PsiImportStaticStatement[] importStatements = isStatic ? this.getImportStaticStatements() : this.getImportStatements();
        return importStatements[importStatements.length - 1];
    }

    public void clearCaches() {
        ((CachedValueBase)this.myImportAttributes).clear();
    }

    @Nullable
    private XmlTag findLastImportDirective() {
        List<XmlTag> importDirectives = this.getAllImportDirectives(false);
        return importDirectives.isEmpty() ? null : importDirectives.get(importDirectives.size() - 1);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "addBefore"));
        }
        return this.addRangeBefore(element, element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "addAfter"));
        }
        return this.addRangeAfter(element, element, anchor);
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "checkAdd"));
        }
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "addRangeBefore"));
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        PsiImportStatement[] importStatements;
        for (PsiImportStatement importStatement : importStatements = this.getImportStatements()) {
            importStatement.delete();
        }
        this.clearCaches();
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl", "replace"));
        }
        if (!(newElement instanceof PsiImportList)) {
            throw new IncorrectOperationException("Can't replace import list with " + newElement);
        }
        PsiImportList importList = (PsiImportList)newElement;
        PsiImportStatement[] jspxImportStatements = this.getImportStatements();
        PsiImportStatement[] importStatements = importList.getImportStatements();
        ArrayList<JspxImportStatementImpl> localImports = new ArrayList<JspxImportStatementImpl>(jspxImportStatements.length);
        ArrayList<JspxImportStatementImpl> includedImports = new ArrayList<JspxImportStatementImpl>(jspxImportStatements.length);
        for (PsiImportStatement jspxImportStatement : jspxImportStatements) {
            JspxImportStatementImpl jspxImportStatementImpl = (JspxImportStatementImpl)jspxImportStatement;
            if (jspxImportStatementImpl.isForeignFileImport()) {
                includedImports.add(jspxImportStatementImpl);
                continue;
            }
            localImports.add(jspxImportStatementImpl);
        }
        Iterator iterator = localImports.iterator();
        block1: for (PsiImportStatement psiImportStatement : importStatements) {
            PsiJavaCodeReferenceElement importReference = psiImportStatement.getImportReference();
            if (importReference == null) continue;
            for (PsiImportStatement psiImportStatement2 : includedImports) {
                PsiJavaCodeReferenceElement reference = psiImportStatement2.getImportReference();
                if (reference == null || !reference.getText().equals(importReference.getText())) continue;
                continue block1;
            }
            if (iterator.hasNext()) {
                ((PsiImportStatement)iterator.next()).replace((PsiElement)psiImportStatement);
                continue;
            }
            this.add((PsiElement)psiImportStatement);
        }
        while (iterator.hasNext()) {
            ((PsiImportStatement)iterator.next()).delete();
        }
        this.clearCaches();
        return this;
    }

    public boolean isValid() {
        return this.myJavaRoot.isValid();
    }

    public boolean isWritable() {
        return this.myJavaRoot.isWritable();
    }

    public boolean isPhysical() {
        return this.myJavaRoot.isPhysical();
    }

    @Nullable
    public ASTNode getNode() {
        return null;
    }

    public String toString() {
        return "JspxImportList";
    }
}

