/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspXml;

import com.intellij.lang.jsp.IBaseJspManager;
import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspDirectiveImpl
extends XmlTagImpl
implements JspDirective {
    @NonNls
    private static final String TAGLIB_DIRECTIVE = "taglib";

    public JspDirectiveImpl() {
        super((IElementType)BaseJspElementType.JSP_DIRECTIVE);
    }

    public XmlElementDescriptor getDescriptor() {
        PsiFile containingFile = this.getContainingFile().getOriginalFile();
        IBaseJspManager jspManager = JspWithOtherWorldIntegrationService.getInstance().getJspManagerInstance(containingFile.getProject());
        return jspManager.getDirectiveDescriptorByName(this.getLocalName(), containingFile);
    }

    @NotNull
    public String getNamespace() {
        if ("http://java.sun.com/JSP/Page" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspXml/JspDirectiveImpl", "getNamespace"));
        }
        return "http://java.sun.com/JSP/Page";
    }

    public String[] knownNamespaces() {
        XmlTag parentTag = this.getParentTag();
        if (parentTag != null) {
            return parentTag.knownNamespaces();
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getPrefixByNamespace(String namespace) {
        XmlTag parentTag = this.getParentTag();
        return parentTag != null ? parentTag.getPrefixByNamespace(namespace) : null;
    }

    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        XmlTag parentTag = this.getParentTag();
        String string = parentTag != null ? parentTag.getNamespaceByPrefix(prefix) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspXml/JspDirectiveImpl", "getNamespaceByPrefix"));
        }
        return string;
    }

    public boolean hasNamespaceDeclarations() {
        return TAGLIB_DIRECTIVE.equals(this.getName());
    }

    @NotNull
    public Map<String, String> getLocalNamespaceDeclarations() {
        if (!this.hasNamespaceDeclarations()) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspXml/JspDirectiveImpl", "getLocalNamespaceDeclarations"));
            }
            return map;
        }
        String prefix = this.getAttributeValue("prefix");
        String uri = this.getAttributeValue("uri");
        if (prefix == null || uri == null) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspXml/JspDirectiveImpl", "getLocalNamespaceDeclarations"));
            }
            return map;
        }
        Map<String, String> map = Collections.singletonMap(prefix, uri);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspXml/JspDirectiveImpl", "getLocalNamespaceDeclarations"));
        }
        return map;
    }
}

