/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.ProcessingContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxIncludePathReferenceProvider
extends PsiReferenceProvider
implements CustomizableReferenceProvider {
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)element;
            String valueString = attributeValue.getValue();
            if (valueString.indexOf(63) >= 0) {
                PsiReference[] psiReferenceArray = this.getReferencesByString(valueString.substring(0, valueString.indexOf(63)), (PsiElement)attributeValue, 1);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            PsiReference[] psiReferenceArray = this.getReferencesByString(valueString, (PsiElement)attributeValue, 1);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            XmlTagValue value = tag.getValue();
            String text = value.getText();
            String trimmedText = text.trim();
            PsiReference[] psiReferenceArray = this.getReferencesByString(trimmedText, (PsiElement)tag, value.getTextRange().getStartOffset() + text.indexOf(trimmedText) - element.getTextOffset());
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    private PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByString"));
        }
        PsiReference[] psiReferenceArray = JspxIncludePathReferenceProvider.getFileReferencesFromString(str, position, offsetInPosition, this);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getReferencesByString"));
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getFileReferencesFromString(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getFileReferencesFromString"));
        }
        return JspxIncludePathReferenceProvider.getFileReferenceSet(str, position, offsetInPosition, provider).getAllReferences();
    }

    public static FileReferenceSet getFileReferenceSet(String str, @NotNull PsiElement position, int offsetInPosition, PsiReferenceProvider provider) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/resolve/reference/impl/providers/JspxIncludePathReferenceProvider", "getFileReferenceSet"));
        }
        return new FileReferenceSet(str, position, offsetInPosition, provider, true){

            protected boolean useIncludingFileAsContext() {
                return false;
            }
        };
    }

    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }
}

