/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration.container;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerParameter;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerUtils;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianMavenCoordinates;
import com.intellij.plugins.jboss.arquillian.configuration.model.ArquillianContainerModel;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianContainerState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.persistent.ArquillianMavenLibraryState;
import com.intellij.plugins.jboss.arquillian.configuration.ui.ArquillianContainerSettings;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import icons.ArquillianIcons;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArquillianContainerImpl
extends ArquillianContainer {
    protected final String id;
    protected final String name;
    protected final String descriptionUri;
    protected final List<ArquillianMavenCoordinates> dependencies;

    public ArquillianContainerImpl(String idSuffix, String name, String descriptionUri, ArquillianMavenCoordinates ... dependencies) {
        this.descriptionUri = descriptionUri;
        this.id = "container.arquillian." + idSuffix;
        this.name = name;
        this.dependencies = Arrays.asList(dependencies);
    }

    public ArquillianContainerImpl(String idSuffix, String name, String descriptionUri, List<ArquillianMavenCoordinates> dependencies) {
        this.descriptionUri = descriptionUri;
        this.id = "container.arquillian." + idSuffix;
        this.name = name;
        this.dependencies = dependencies;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainerImpl", "getId"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainerImpl", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getDescriptionUri() {
        return this.descriptionUri;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = ArquillianIcons.Arquillian;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainerImpl", "getIcon"));
        }
        return icon;
    }

    @Override
    @NotNull
    public List<ArquillianMavenCoordinates> getDependencies() {
        List<ArquillianMavenCoordinates> list = this.dependencies;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainerImpl", "getDependencies"));
        }
        return list;
    }

    @Override
    public List<ArquillianContainerParameter> getParameters() {
        return Lists.newArrayList();
    }

    @Override
    @NotNull
    public ArquillianContainerState createDefaultState(Project project, String name) {
        ArquillianContainerState state = new ArquillianContainerState(this.getId(), name, JBIterable.from(this.dependencies).transform((Function)new Function<ArquillianMavenCoordinates, ArquillianLibraryState>(){

            public ArquillianLibraryState fun(ArquillianMavenCoordinates coordinates) {
                return new ArquillianMavenLibraryState(coordinates);
            }
        }).toList());
        ArquillianContainerUtils.loadDependenciesAsync(project, state);
        ArquillianContainerState arquillianContainerState = state;
        if (arquillianContainerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/container/ArquillianContainerImpl", "createDefaultState"));
        }
        return arquillianContainerState;
    }

    @Override
    public JPanel createSettingsPanel(Project project, ArquillianContainerModel model) {
        ArquillianContainerSettings settings = new ArquillianContainerSettings(project, this, model);
        return settings.getMainPanel();
    }
}

