/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.plugins.jboss.arquillian.ArquillianBundle;
import com.intellij.psi.EmptySubstitutor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArquillianDeploymentSignatureInspection
extends BaseJavaLocalInspectionTool {
    private static void checkModifiersAndReturnType(@NotNull PsiMethod method, @NotNull PsiAnnotation deploymentAnnotation, @NotNull ProblemsHolder holder) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkModifiersAndReturnType"));
        }
        if (deploymentAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentAnnotation", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkModifiersAndReturnType"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkModifiersAndReturnType"));
        }
        ArrayList<LocalQuickFixAndIntentionActionOnPsiElement> fixes = new ArrayList<LocalQuickFixAndIntentionActionOnPsiElement>();
        PsiModifierList modifierList = method.getModifierList();
        if (!modifierList.hasModifierProperty("static")) {
            fixes.add(QuickFixFactory.getInstance().createModifierListFix(modifierList, "static", true, true));
        }
        if (!modifierList.hasModifierProperty("public")) {
            fixes.add(QuickFixFactory.getInstance().createModifierListFix(modifierList, "public", true, true));
        }
        if (fixes.isEmpty()) {
            return;
        }
        holder.registerProblem((PsiElement)deploymentAnnotation, ArquillianBundle.message("arquillian.deployment.wrong.signature", new Object[0]), fixes.toArray(new LocalQuickFix[fixes.size()]));
    }

    private static void checkWrongParameterCount(@NotNull PsiMethod method, @NotNull PsiAnnotation deploymentAnnotation, @NotNull ProblemsHolder holder) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkWrongParameterCount"));
        }
        if (deploymentAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deploymentAnnotation", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkWrongParameterCount"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkWrongParameterCount"));
        }
        RemoveAnnotationQuickFix removeAnnotationQuickFix = new RemoveAnnotationQuickFix(deploymentAnnotation, (PsiModifierListOwner)method);
        IntentionAction changeMethodSignatureFix = QuickFixFactory.getInstance().createChangeMethodSignatureFromUsageFix(method, new PsiExpression[0], (PsiSubstitutor)EmptySubstitutor.getInstance(), (PsiElement)method, false, 111);
        holder.registerProblem((PsiElement)deploymentAnnotation, ArquillianBundle.message("arquillian.deployment.wrong.signature", new Object[0]), new LocalQuickFix[]{new IntentionWrapper(changeMethodSignatureFix, method.getContainingFile()), removeAnnotationQuickFix});
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/plugins/jboss/arquillian/inspection/ArquillianDeploymentSignatureInspection", "checkMethod"));
        }
        PsiAnnotation deploymentAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.jboss.arquillian.container.test.api.Deployment"});
        if (deploymentAnnotation == null) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, method.getContainingFile(), isOnTheFly);
        if (method.getParameterList().getParametersCount() > 0) {
            ArquillianDeploymentSignatureInspection.checkWrongParameterCount(method, deploymentAnnotation, holder);
        }
        ArquillianDeploymentSignatureInspection.checkModifiersAndReturnType(method, deploymentAnnotation, holder);
        List problemDescriptors = holder.getResults();
        return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
    }
}

