/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArquillianUtils {
    public static boolean isJunitArquillianEnabled(ConfigurationContext context) {
        Location contextLocation = context.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiClass testClass = JUnitUtil.getTestClass((Location)location);
        return testClass != null && ArquillianUtils.isJunitArquillianEnabled(testClass);
    }

    public static boolean isJunitArquillianEnabled(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils", "isJunitArquillianEnabled"));
        }
        return ArquillianUtils.getJunitArquillianEnabledElement(aClass) != null;
    }

    public static PsiElement getJunitArquillianEnabledElement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils", "getJunitArquillianEnabledElement"));
        }
        PsiModifierList classModifierList = aClass.getModifierList();
        if (classModifierList == null) {
            return null;
        }
        PsiAnnotation runWithAnnotation = classModifierList.findAnnotation("org.junit.runner.RunWith");
        if (runWithAnnotation == null) {
            return null;
        }
        for (PsiNameValuePair nameValuePair : runWithAnnotation.getParameterList().getAttributes()) {
            String name = nameValuePair.getName();
            if (name != null && !name.equals("value")) continue;
            PsiAnnotationMemberValue value = nameValuePair.getValue();
            if (!(value instanceof PsiClassObjectAccessExpression)) {
                return null;
            }
            PsiTypeElement typeElement = ((PsiClassObjectAccessExpression)value).getOperand();
            PsiClassType arquillianJunitType = PsiType.getTypeByName((String)"org.jboss.arquillian.junit.Arquillian", (Project)aClass.getProject(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)aClass.getProject()));
            return arquillianJunitType.isAssignableFrom(typeElement.getType()) ? runWithAnnotation : null;
        }
        return null;
    }

    public static PsiElement getTestngArquillianEnabledElement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils", "getTestngArquillianEnabledElement"));
        }
        PsiClass psiClass = ArquillianUtils.getTestngArquillianType(aClass.getProject()).resolve();
        return psiClass != null && aClass.isInheritor(psiClass, true) ? aClass.getExtendsList() : null;
    }

    public static boolean isTestngArquillianEnabled(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils", "isTestngArquillianEnabled"));
        }
        PsiClass psiClass = ArquillianUtils.getTestngArquillianType(aClass.getProject()).resolve();
        return psiClass != null && aClass.isInheritor(psiClass, true);
    }

    public static PsiClassType getTestngArquillianType(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils", "getTestngArquillianType"));
        }
        return PsiType.getTypeByName((String)"org.jboss.arquillian.testng.Arquillian", (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
    }

    public static List<PsiMethod> getAnnotatedMethods(@NotNull PsiClass aClass, @NonNls @NotNull String annotationFQN) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils", "getAnnotatedMethods"));
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationFQN", "com/intellij/plugins/jboss/arquillian/utils/ArquillianUtils", "getAnnotatedMethods"));
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        for (PsiMethod method : aClass.getAllMethods()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)annotationFQN, (boolean)false)) continue;
            result.add(method);
        }
        return result;
    }

    public static boolean isClassAvailableInContext(ConfigurationContext context, String fqn) {
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)context.getPsiLocation());
        if (context.getLocation() == null || psiPackage == null) {
            return false;
        }
        return LocationUtil.isJarAttached((Location)context.getLocation(), (PsiPackage)psiPackage, (String)fqn);
    }
}

