/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.diagram;

import com.intellij.openapi.graph.builder.CachedGraphDataModel;
import com.intellij.openapi.paths.PathReference;
import com.intellij.psi.PsiElement;
import com.intellij.struts.diagram.StrutsEdgeObject;
import com.intellij.struts.diagram.StrutsNodeObject;
import com.intellij.struts.diagram.StrutsObject;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.Exception;
import com.intellij.struts.dom.Forward;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.util.xml.GenericValue;
import icons.StrutsApiIcons;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StrutsGraphDataModel
extends CachedGraphDataModel<StrutsObject, StrutsObject> {
    private final StrutsConfig myStrutsConfig;

    public StrutsGraphDataModel(StrutsConfig strutsConfig) {
        this.myStrutsConfig = strutsConfig;
    }

    protected void createEdge(StrutsObject source, @NonNls String name, GenericValue<PathReference> pathValue, boolean reverse) {
        StrutsNodeObject target;
        PathReference webPath = (PathReference)pathValue.getValue();
        if (webPath != null) {
            target = new StrutsNodeObject(webPath);
        } else {
            String path = pathValue.getStringValue();
            if (path == null || path.length() == 0) {
                return;
            }
            target = new StrutsNodeObject(path);
        }
        this.createNode(target);
        StrutsEdgeObject edge = new StrutsEdgeObject(source.getName(), name);
        if (reverse) {
            this.createEdge(edge, target, source);
        } else {
            this.createEdge(edge, source, target);
        }
    }

    public StrutsObject createEdge(@NotNull StrutsObject from, @NotNull StrutsObject to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/struts/diagram/StrutsGraphDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/struts/diagram/StrutsGraphDataModel", "createEdge"));
        }
        return (StrutsObject)super.createEdge((Object)from, (Object)to);
    }

    protected void buildGraph() {
        StrutsNodeObject source;
        String name;
        this.clear();
        for (Forward forward : this.myStrutsConfig.getGlobalForwards().getForwards()) {
            name = forward.getName().getStringValue();
            if (name == null) continue;
            source = new StrutsNodeObject(name, StrutsApiIcons.GlobalForwards, (PsiElement)forward.getXmlTag());
            this.createNode(source);
            this.createEdge(source, "", (GenericValue<PathReference>)forward.getPath(), false);
        }
        for (Exception exception : this.myStrutsConfig.getGlobalExceptions().getExceptions()) {
            name = exception.getKey().getStringValue();
            if (name == null) continue;
            source = new StrutsNodeObject(name, StrutsApiIcons.GlobalException, (PsiElement)exception.getXmlTag());
            this.createNode(source);
            this.createEdge(source, "", (GenericValue<PathReference>)exception.getPath(), false);
        }
        for (Action action : this.myStrutsConfig.getActionMappings().getActions()) {
            name = action.getPath().getStringValue();
            if (name == null) continue;
            source = new StrutsNodeObject(name, StrutsApiIcons.ActionMapping, (PsiElement)action.getXmlTag());
            this.createNode(source);
            for (Forward forward : action.getForwards()) {
                this.createEdge(source, forward.getName().getStringValue(), (GenericValue<PathReference>)forward.getPath(), false);
            }
            for (Exception exception : action.getExceptions()) {
                this.createEdge(source, exception.getKey().getStringValue(), (GenericValue<PathReference>)exception.getPath(), false);
            }
            this.createEdge(source, "forward", (GenericValue<PathReference>)action.getForward(), false);
            this.createEdge(source, "include", (GenericValue<PathReference>)action.getInclude(), false);
            this.createEdge(source, "input", (GenericValue<PathReference>)action.getInput(), true);
        }
    }

    @NotNull
    public String getNodeName(StrutsObject strutsObject) {
        String string = strutsObject.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/diagram/StrutsGraphDataModel", "getNodeName"));
        }
        return string;
    }

    @NotNull
    public String getEdgeName(StrutsObject strutsObject) {
        String string = strutsObject.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/diagram/StrutsGraphDataModel", "getEdgeName"));
        }
        return string;
    }
}

