/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.facet.StrutsFacet;
import com.intellij.struts.facet.StrutsFacetConfiguration;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class StrutsValidatorBase
extends InspectionValidator {
    protected StrutsValidatorBase(@NotNull String description, @NotNull String progressIndicatorText) {
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/struts/highlighting/StrutsValidatorBase", "<init>"));
        }
        if (progressIndicatorText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicatorText", "com/intellij/struts/highlighting/StrutsValidatorBase", "<init>"));
        }
        super(description, progressIndicatorText);
    }

    protected abstract DomModelFactory getFactory(Project var1);

    @NotNull
    protected Set<XmlFile> getConfigFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts/highlighting/StrutsValidatorBase", "getConfigFiles"));
        }
        Set set = this.getFactory(module.getProject()).getAllConfigFiles((UserDataHolder)module);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/highlighting/StrutsValidatorBase", "getConfigFiles"));
        }
        return set;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/struts/highlighting/StrutsValidatorBase", "isAvailableOnScope"));
        }
        Module[] modules = scope.getAffectedModules();
        return !JavaeeFacetUtil.getInstance().getJavaeeFacets(WebFacet.ID, modules).isEmpty();
    }

    protected abstract boolean isAvailableOnFacet(StrutsFacet var1);

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collection webFacets = WebFacet.getInstances((Module)module);
            boolean containsStruts = false;
            for (WebFacet webFacet : webFacets) {
                StrutsFacet strutsFacet = StrutsFacet.getInstance(webFacet);
                if (strutsFacet == null || !this.isAvailableOnFacet(strutsFacet)) continue;
                containsStruts = true;
            }
            if (!containsStruts) continue;
            Set<XmlFile> psiFiles = this.getConfigFiles(module);
            for (PsiFile psiFile : psiFiles) {
                ContainerUtil.addIfNotNull((Object)psiFile.getVirtualFile(), list);
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(list, (CompileContext)context);
        return list;
    }

    @NotNull
    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/highlighting/StrutsValidatorBase", "getDependencies"));
            }
            return list;
        }
        Set<XmlFile> psiFiles = this.getConfigFiles(module);
        psiFiles.remove(psiFile);
        Set<XmlFile> set = psiFiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/highlighting/StrutsValidatorBase", "getDependencies"));
        }
        return set;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(@NotNull HighlightDisplayLevel severity, @NotNull VirtualFile virtualFile, @NotNull CompileContext context) {
        StrutsFacet facet;
        WebFacet webFacet;
        Module module;
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/struts/highlighting/StrutsValidatorBase", "getCategoryByHighlightDisplayLevel"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/struts/highlighting/StrutsValidatorBase", "getCategoryByHighlightDisplayLevel"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts/highlighting/StrutsValidatorBase", "getCategoryByHighlightDisplayLevel"));
        }
        CompilerMessageCategory level = super.getCategoryByHighlightDisplayLevel(severity, virtualFile, context);
        if (level == CompilerMessageCategory.ERROR && (module = context.getModuleByFile(virtualFile)) != null && (webFacet = WebUtil.getWebFacet((VirtualFile)virtualFile, (Project)module.getProject())) != null && (facet = StrutsFacet.getInstance(webFacet)) != null && ((StrutsFacetConfiguration)facet.getConfiguration()).getValidationConfiguration().myReportErrorsAsWarnings) {
            return CompilerMessageCategory.WARNING;
        }
        return level;
    }
}

