/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.jsp.jspXml.JspExpression;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class InplaceUtil {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(".*\\{\\d}.*");

    private InplaceUtil() {
    }

    public static boolean isSimpleText(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/InplaceUtil", "isSimpleText"));
        }
        return PsiTreeUtil.getChildOfType((PsiElement)psiElement, OuterLanguageElement.class) == null && PsiTreeUtil.getChildOfType((PsiElement)psiElement, JspExpression.class) == null;
    }

    public static boolean containsPlaceholderReference(String text) {
        return StringUtil.isNotEmpty((String)text) && PLACEHOLDER_PATTERN.matcher(text).matches();
    }
}

