/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.gutter;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.inplace.gutter.GutterIconRendererBase;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GotoDeclGutter
extends GutterIconRendererBase
implements DumbAware {
    private final PsiElement myElement;
    private final String myTooltip;
    private final AnAction myClickAction;
    private static final DomElementListCellRenderer DOM_ELEMENT_LIST_CELL_RENDERER = new DomElementListCellRenderer();

    protected GotoDeclGutter(@NotNull PsiElement element, @NotNull Icon icon, String tooltip) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/gutter/GotoDeclGutter", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/struts/inplace/gutter/GotoDeclGutter", "<init>"));
        }
        super(icon);
        this.myElement = element;
        this.myTooltip = tooltip;
        this.myClickAction = new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                DomElement[] elements = GotoDeclGutter.this.getDestinations(GotoDeclGutter.this.myElement);
                if (elements != null && elements.length != 0) {
                    if (elements.length == 1) {
                        XmlTag element = elements[0].getXmlTag();
                        if (element instanceof Navigatable && ((Navigatable)element).canNavigateToSource()) {
                            ((Navigatable)element).navigate(true);
                        }
                    } else {
                        JBPopup gotoDeclarationPopup = NavigationUtil.getPsiElementPopup((PsiElement[])DomUtil.getElementTags((DomElement[])elements), (PsiElementListCellRenderer)DOM_ELEMENT_LIST_CELL_RENDERER, (String)("Goto " + elements[0].getPresentation().getTypeName() + " Declaration"));
                        gotoDeclarationPopup.show(new RelativePoint((MouseEvent)e.getInputEvent()));
                    }
                }
            }
        };
    }

    @Nullable
    protected abstract DomElement[] getDestinations(@NotNull PsiElement var1);

    @Nullable
    public String getTooltipText() {
        return this.myTooltip;
    }

    @Nullable
    public AnAction getClickAction() {
        return this.myClickAction;
    }

    public boolean isNavigateAction() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GotoDeclGutter that = (GotoDeclGutter)((Object)o);
        if (this.myElement != null ? !this.myElement.equals(that.myElement) : that.myElement != null) {
            return false;
        }
        if (this.myTooltip != null ? !this.myTooltip.equals(that.myTooltip) : that.myTooltip != null) {
            return false;
        }
        return this.getIcon().equals(that.getIcon());
    }

    public int hashCode() {
        int result = this.myElement != null ? this.myElement.hashCode() : 0;
        result = 31 * result + (this.myTooltip != null ? this.myTooltip.hashCode() : 0);
        return result;
    }

    private static class DomElementListCellRenderer
    extends PsiElementListCellRenderer {
        private DomElementListCellRenderer() {
        }

        public String getElementText(PsiElement psiElement) {
            return DomElementListCellRenderer.getDomElementPresentation(psiElement).getElementName();
        }

        protected String getContainerText(PsiElement psiElement, String s) {
            StrutsModel model = StrutsManager.getInstance().getStrutsModel(psiElement);
            if (model != null) {
                return '[' + model.getModulePrefix() + ']';
            }
            return '(' + psiElement.getContainingFile().getName() + ')';
        }

        protected Icon getIcon(PsiElement psiElement) {
            return DomElementListCellRenderer.getDomElementPresentation(psiElement).getIcon();
        }

        protected int getIconFlags() {
            return 0;
        }

        @NotNull
        private static ElementPresentation getDomElementPresentation(PsiElement psiElement) {
            DomElement domElement = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement((XmlTag)psiElement);
            assert (domElement != null);
            ElementPresentation elementPresentation = domElement.getPresentation();
            if (elementPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/gutter/GotoDeclGutter$DomElementListCellRenderer", "getDomElementPresentation"));
            }
            return elementPresentation;
        }
    }
}

