/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PlainTextManipulator
extends AbstractElementManipulator<PsiPlainText> {
    public PsiPlainText handleContentChange(@NotNull PsiPlainText plainText, @NotNull TextRange textRange, String newContent) throws IncorrectOperationException {
        if (plainText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plainText", "com/intellij/play/references/PlainTextManipulator", "handleContentChange"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/play/references/PlainTextManipulator", "handleContentChange"));
        }
        PsiPlainTextFile file = (PsiPlainTextFile)plainText.getParent();
        String oldText = file.getText();
        String newText = oldText.substring(0, textRange.getStartOffset()) + newContent + oldText.substring(textRange.getEndOffset());
        PsiPlainTextFile psiFile = (PsiPlainTextFile)PsiFileFactory.getInstance((Project)file.getProject()).createFileFromText("__plain.txt", newText);
        PsiElement newPlainText = psiFile.getChildren()[0];
        file.getChildren()[0].replace(newPlainText);
        return (PsiPlainText)file.getChildren()[0];
    }
}

