/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.config.model.xml;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.spring.webflow.config.model.xml.version1_0.Location;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowLocation;
import com.intellij.spring.webflow.config.model.xml.version2_0.FlowLocationPattern;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class WebflowResourceTypeProvider
implements SpringResourceTypeProvider {
    private static final Condition<PsiFileSystemItem> FLOW_XML_CONDITION = new Condition<PsiFileSystemItem>(){

        public boolean value(PsiFileSystemItem item) {
            VirtualFile virtualFile = item.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            PsiFile file = item.getManager().findFile(virtualFile);
            return file instanceof XmlFile && WebflowDomModelManager.getInstance(item.getProject()).isWebflow((XmlFile)file);
        }
    };

    public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/webflow/config/model/xml/WebflowResourceTypeProvider", "getResourceFilter"));
        }
        String name = genericDomValue.getXmlElementName();
        if (Comparing.equal((String)name, (String)"path") && (WebflowResourceTypeProvider.hasParentOfType(genericDomValue, FlowLocation.class) || WebflowResourceTypeProvider.hasParentOfType(genericDomValue, Location.class))) {
            return FLOW_XML_CONDITION;
        }
        if (Comparing.equal((String)name, (String)"value") && WebflowResourceTypeProvider.hasParentOfType(genericDomValue, FlowLocationPattern.class)) {
            return FLOW_XML_CONDITION;
        }
        return null;
    }

    private static boolean hasParentOfType(GenericDomValue value, Class<? extends DomElement> parentClass) {
        return value.getParentOfType(parentClass, true) != null;
    }
}

