/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.webflow.el.ELVariablesCollectorUtils;
import com.intellij.spring.webflow.util.WebflowUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebflowElVariablesProvider
extends ElVariablesProvider {
    public boolean processImplicitVariables(@NotNull PsiElement element, @NotNull ELExpressionHolder containingFile, @NotNull ELElementProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/el/WebflowElVariablesProvider", "processImplicitVariables"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/spring/webflow/el/WebflowElVariablesProvider", "processImplicitVariables"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/webflow/el/WebflowElVariablesProvider", "processImplicitVariables"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (!WebflowUtil.isWebFlowAvailable(module)) {
            return true;
        }
        final PsiFile jspFile = containingFile.getContainingFile();
        List variables = (List)CachedValuesManager.getCachedValue((PsiElement)jspFile, (CachedValueProvider)new CachedValueProvider<List<PsiVariable>>(){

            public CachedValueProvider.Result<List<PsiVariable>> compute() {
                List variables = WebflowElVariablesProvider.getVariables(jspFile);
                return CachedValueProvider.Result.create((Object)variables, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
        for (PsiVariable variable : variables) {
            if (processor.processVariable(variable)) continue;
            return false;
        }
        return true;
    }

    private static List<PsiVariable> getVariables(PsiFile jspFile) {
        List<PsiVariable> variables = ELVariablesCollectorUtils.getVariables((PsiElement)jspFile, ELVariablesCollectorUtils.CollectType.DEFAULT, ELVariablesCollectorUtils.CollectScope.VIEW, null);
        if (variables.isEmpty()) {
            variables = ELVariablesCollectorUtils.getVariables((PsiElement)jspFile, ELVariablesCollectorUtils.CollectType.DEFAULT, ELVariablesCollectorUtils.CollectScope.MODULE, null);
        }
        return variables;
    }
}

