/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyFix;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.spring.webflow.model.converters.BindingPropertyReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BindingPropertyReference
extends PsiReferenceBase<PsiElement>
implements LocalQuickFixProvider {
    private static final Function<BeanProperty, PsiNamedElement> BEAN_PROPERTY_PSI_MAPPER = new Function<BeanProperty, PsiNamedElement>(){

        public PsiNamedElement fun(BeanProperty beanProperty) {
            return beanProperty.getPsiElement();
        }
    };
    private static final NullableFunction<PsiMethod, BeanProperty> BEAN_PROPERTY_MAPPER = new NullableFunction<PsiMethod, BeanProperty>(){

        @Nullable
        public BeanProperty fun(PsiMethod method) {
            return BeanProperty.createBeanProperty((PsiMethod)method);
        }
    };
    private final BindingPropertyReferenceSet mySet;
    private final int myIndex;
    private final boolean myHasIndexAccess;

    BindingPropertyReference(BindingPropertyReferenceSet set, TextRange range, int index) {
        super(set.getElement(), range, true);
        this.mySet = set;
        this.myIndex = index;
        String value = this.getValue();
        int indexStartIdx = value.indexOf("[");
        boolean bl = this.myHasIndexAccess = indexStartIdx != -1 && value.endsWith("]");
        if (this.myHasIndexAccess) {
            this.setRangeInElement(TextRange.from((int)range.getStartOffset(), (int)indexStartIdx));
        }
    }

    @Nullable
    private PsiClass getPsiClass() {
        if (this.isFirst()) {
            return this.mySet.getModelClass();
        }
        BindingPropertyReference reference = (BindingPropertyReference)this.mySet.getReference(this.myIndex - 1);
        PsiMethod psiMethod = (PsiMethod)reference.resolve();
        if (psiMethod == null) {
            return null;
        }
        PsiType type = psiMethod.getReturnType();
        if (type == null) {
            return null;
        }
        boolean usingIndexAccess = reference.hasIndexAccess();
        if (usingIndexAccess) {
            type = type.getDeepComponentType();
        }
        if (type instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)type;
            PsiClass psiClass = psiClassType.resolve();
            if (usingIndexAccess && psiClassType.getParameterCount() == 1 && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.List") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.util.Set")) {
                PsiType collectionElementType = psiClassType.getParameters()[0];
                return collectionElementType instanceof PsiClassType ? ((PsiClassType)collectionElementType).resolve() : null;
            }
            return psiClass;
        }
        return null;
    }

    private boolean isFirst() {
        return this.myIndex == 0;
    }

    private boolean hasIndexAccess() {
        return this.myHasIndexAccess;
    }

    public PsiElement resolve() {
        PsiClass psiClass = this.getPsiClass();
        String propertyName = this.getValue();
        return PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ContainerUtil.map2Array(this.resolveProperties(), PsiNamedElement.class, BEAN_PROPERTY_PSI_MAPPER);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/BindingPropertyReference", "getVariants"));
        }
        return objectArray;
    }

    private List<BeanProperty> resolveProperties() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return Collections.emptyList();
        }
        Map properties = PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)false, (boolean)true, (boolean)true);
        return ContainerUtil.mapNotNull(properties.values(), BEAN_PROPERTY_MAPPER);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name = PropertyUtil.getPropertyName((String)newElementName);
        return super.handleElementRename(name == null ? newElementName : name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String propertyName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/webflow/model/converters/BindingPropertyReference", "bindToElement"));
        }
        if (element instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)((PsiMember)element))) != null) {
            return super.handleElementRename(propertyName);
        }
        return this.getElement();
    }

    public LocalQuickFix[] getQuickFixes() {
        if (this.resolve() != null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return CreateBeanPropertyFix.createFixes((String)this.getValue(), (PsiClass)psiClass, null, (boolean)false);
    }
}

