/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentation;
import java.util.List;

final class WebflowLookupUtil {
    private static final Function<Flow, LookupElement> FLOW_VARIANT_MAPPER = new Function<Flow, LookupElement>(){

        public LookupElement fun(Flow flow) {
            return WebflowLookupUtil.forFlow(flow);
        }
    };

    WebflowLookupUtil() {
    }

    static LookupElement forIdentified(Identified identified) {
        ElementPresentation elementPresentation = identified.getPresentation();
        return LookupElementBuilder.create((Object)identified.getXmlTag(), (String)StringUtil.notNullize((String)elementPresentation.getElementName())).withIcon(elementPresentation.getIcon()).withTailText(" (" + identified.getXmlTag().getContainingFile().getName() + ")", true);
    }

    static LookupElement[] forFlows(List<Flow> flows) {
        return (LookupElement[])ContainerUtil.map2Array(flows, LookupElement.class, FLOW_VARIANT_MAPPER);
    }

    static LookupElement forFlow(Flow flow) {
        String flowName = WebflowUtil.getFlowName(flow);
        LookupElementBuilder builder = LookupElementBuilder.create((Object)flow.getXmlTag(), (String)StringUtil.notNullize((String)flowName, (String)"???")).withIcon(flow.getPresentation().getIcon());
        VirtualFile flowVirtualFile = DomUtil.getFile((DomElement)flow).getVirtualFile();
        if (flowVirtualFile == null) {
            return builder;
        }
        Project project = flow.getManager().getProject();
        VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(flowVirtualFile);
        if (root == null) {
            return builder;
        }
        return builder.withTailText(" (" + VfsUtilCore.getRelativePath((VirtualFile)flowVirtualFile, (VirtualFile)root, (char)'/') + ")", true);
    }
}

