/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.util;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.webflow.el.inject.ExpressionLanguageConfiguration;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowUtil {
    private static final Set<String> EXPRESSION_PREFIXES = new HashSet<String>();

    private WebflowUtil() {
    }

    public static boolean isDynamicExpression(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/webflow/util/WebflowUtil", "isDynamicExpression"));
        }
        for (String prefix : EXPRESSION_PREFIXES) {
            if (!value.contains(prefix)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Flow> getAllFlows(@NotNull Module module, @NotNull List<PsiFile> exceptedFiles) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/util/WebflowUtil", "getAllFlows"));
        }
        if (exceptedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptedFiles", "com/intellij/spring/webflow/util/WebflowUtil", "getAllFlows"));
        }
        ArrayList<Flow> flows = new ArrayList<Flow>();
        for (WebflowModel model : WebflowDomModelManager.getInstance(module.getProject()).getAllModels(module)) {
            if (exceptedFiles.contains(model.getFlowFile())) continue;
            flows.add(model.getFlow());
        }
        ArrayList<Flow> arrayList = flows;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowUtil", "getAllFlows"));
        }
        return arrayList;
    }

    @Nullable
    public static XmlFile resolveFlow(@NotNull Flow flow) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/spring/webflow/util/WebflowUtil", "resolveFlow"));
        }
        WebflowModel model = WebflowUtil.getModelByFlow(flow);
        return model != null ? model.getFlowFile() : null;
    }

    @Nullable(value="if flow has no underlying model (not configured)")
    public static String getFlowName(@NotNull Flow flow) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/spring/webflow/util/WebflowUtil", "getFlowName"));
        }
        WebflowModel model = WebflowUtil.getModelByFlow(flow);
        return model != null ? model.getName() : null;
    }

    @Nullable
    private static WebflowModel getModelByFlow(@NotNull Flow flow) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/spring/webflow/util/WebflowUtil", "getModelByFlow"));
        }
        return WebflowDomModelManager.getInstance(flow.getManager().getProject()).getWebflowModel(DomUtil.getFile((DomElement)flow));
    }

    public static boolean isNonSingletonPrototype(CommonSpringBean bean) {
        if (!(bean instanceof SpringBean)) {
            return false;
        }
        SpringBean springBean = (SpringBean)bean;
        Boolean isSingleton = (Boolean)springBean.getSingleton().getValue();
        if (Boolean.TRUE == isSingleton) {
            return false;
        }
        SpringBeanScope scope = (SpringBeanScope)springBean.getScope().getValue();
        return scope == SpringBeanScope.PROTOTYPE_SCOPE;
    }

    public static boolean isWebFlowAvailable(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.webflow.execution.Action") != null;
    }

    static {
        for (ExpressionLanguageConfiguration configuration : ExpressionLanguageConfiguration.values()) {
            EXPRESSION_PREFIXES.add(configuration.getDetectionPrefix());
        }
    }
}

