/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationUtil {
    private static final Condition<PsiClass> RUNNABLE_CONDITION = new Condition<PsiClass>(){

        public boolean value(PsiClass psiClass) {
            return PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true);
        }
    };

    public static boolean isSpringApplication(PsiClass psiClass) {
        if (!RUNNABLE_CONDITION.value((Object)psiClass)) {
            return false;
        }
        EnableAutoConfiguration element = (EnableAutoConfiguration)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{EnableAutoConfiguration.META});
        return element != null;
    }

    public static List<PsiClass> getSpringApplications(final Module module) {
        if (DumbService.isDumb((Project)module.getProject())) {
            return Collections.emptyList();
        }
        if (SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.autoconfigure.EnableAutoConfiguration") == null) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<List<PsiClass>>(){

            @Nullable
            public CachedValueProvider.Result<List<PsiClass>> compute() {
                JamService jamService = JamService.getJamService((Project)module.getProject());
                GlobalSearchScope scope = module.getModuleScope(false);
                ArrayList<String> fqns = new ArrayList<String>((Collection)EnableAutoConfiguration.getAnnotations().fun((Object)module));
                fqns.add("org.springframework.boot.autoconfigure.EnableAutoConfiguration");
                SmartList applications = new SmartList();
                for (String fqn : fqns) {
                    List elements = jamService.getJamClassElements(EnableAutoConfiguration.JAM_KEY, fqn, scope);
                    for (EnableAutoConfiguration element : elements) {
                        PsiClass annotatedClass = element.getPsiElement();
                        if (!RUNNABLE_CONDITION.value((Object)annotatedClass)) continue;
                        applications.add(annotatedClass);
                    }
                }
                return CachedValueProvider.Result.create((Object)applications, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
        });
    }
}

