/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.jam.AopJavaAnnotator;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.aop.DeclareParents;
import com.intellij.spring.model.xml.aop.SpringAopAdvice;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.util.XmlTagUtil;
import icons.AopCommonIcons;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAopAnnotator
extends LineMarkerProviderDescriptor {
    public String getId() {
        return "SpringAopAnnotator";
    }

    @NotNull
    public String getName() {
        if ("AOP (XML)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/aop/SpringAopAnnotator", "getName"));
        }
        return "AOP (XML)";
    }

    @Nullable
    public Icon getIcon() {
        return AopCommonIcons.Abstract_advice;
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/aop/SpringAopAnnotator", "getLineMarkerInfo"));
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/spring/aop/SpringAopAnnotator", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/aop/SpringAopAnnotator", "collectSlowLineMarkers"));
        }
        if (elements.isEmpty()) {
            return;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (!(file instanceof XmlFile)) {
            return;
        }
        XmlFile xmlFile = (XmlFile)file;
        if (!SpringDomUtils.isSpringXml((XmlFile)xmlFile)) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ProgressManager.checkCanceled();
            PsiElement element = elements.get(i);
            SpringAopAnnotator.annotate(element, result);
        }
    }

    private static void annotate(PsiElement psiElement, Collection<LineMarkerInfo> result) {
        XmlTag tag;
        if (psiElement instanceof XmlToken && psiElement.getParent() instanceof XmlTag && XmlTagUtil.getStartTagNameElement((XmlTag)(tag = (XmlTag)psiElement.getParent())) == psiElement) {
            PsiClass psiClass;
            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(tag);
            if (element instanceof SpringAopAdvice) {
                SpringAopAdvice advice = (SpringAopAdvice)element;
                result.add((LineMarkerInfo)AopJavaAnnotator.addNavigationToInterceptedMethods((AopAdvice)advice, (AopAdvisedElementsSearcher)advice.getSearcher()).createLineMarkerInfo(psiElement));
            } else if (element instanceof DeclareParents) {
                NavigationGutterIconBuilder builder = AopJavaAnnotator.addNavigationToIntroducedClasses((AopIntroduction)((DeclareParents)element));
                if (builder != null) {
                    result.add((LineMarkerInfo)builder.createLineMarkerInfo(psiElement));
                }
            } else if (element instanceof DomSpringBean && (psiClass = ((DomSpringBean)element).getBeanClass()) != null) {
                List introductions;
                Map advices = AopJavaAnnotator.getBoundAdvices((PsiClass)psiClass);
                if (!advices.isEmpty()) {
                    result.add((LineMarkerInfo)AopJavaAnnotator.addNavigationToBoundAdvices((Map)advices).createLineMarkerInfo(psiElement));
                }
                if (!(introductions = AopJavaAnnotator.getBoundIntroductions((PsiClass)psiClass)).isEmpty()) {
                    result.add((LineMarkerInfo)AopJavaAnnotator.addNavigationToBoundIntroductions((List)introductions).createLineMarkerInfo(psiElement));
                }
            }
        }
    }
}

