/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestParamTypeInspection
extends AbstractRestJavaInspection {
    private static Collection<String> PARAM_ANNOTATIONS = Arrays.asList("javax.ws.rs.PathParam", "javax.ws.rs.QueryParam", "javax.ws.rs.MatrixParam", "javax.ws.rs.HeaderParam", "javax.ws.rs.FormParam", "javax.ws.rs.CookieParam");

    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "checkMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "checkMethod"));
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            PsiIdentifier nameIdentifier;
            PsiType parameterType;
            PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, PARAM_ANNOTATIONS);
            if (psiAnnotation == null || RestParamTypeInspection.acceptSimpleType(parameterType = parameter.getType()) || RestParamTypeInspection.acceptCollectionType(parameterType) || "javax.ws.rs.PathParam".equals(psiAnnotation.getQualifiedName()) && RestParamTypeInspection.acceptPathSegmentType(parameterType) || "javax.ws.rs.CookieParam".equals(psiAnnotation.getQualifiedName()) && RestParamTypeInspection.acceptCookieType(parameterType) || (nameIdentifier = parameter.getNameIdentifier()) == null) continue;
            holder.registerProblem((PsiElement)nameIdentifier, RSBundle.message("RestParamTypeInspection.incorrect.parameter.type", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    private static boolean acceptPathSegmentType(PsiType parameterType) {
        PsiClass psiClass;
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javax.ws.rs.core.PathSegment")) {
                return true;
            }
            PsiType itType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Collection", (int)0, (boolean)false);
            return itType != null && RestParamTypeInspection.acceptPathSegmentType(itType);
        }
        return false;
    }

    private static boolean acceptCookieType(PsiType parameterType) {
        PsiClass psiClass;
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javax.ws.rs.core.Cookie");
        }
        return false;
    }

    private static boolean acceptCollectionType(@NotNull PsiType parameterType) {
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "acceptCollectionType"));
        }
        if (parameterType instanceof PsiClassType) {
            PsiType itType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Collection", (int)0, (boolean)false);
            return itType != null && RestParamTypeInspection.acceptSimpleType(itType);
        }
        return false;
    }

    private static boolean acceptSimpleType(@NotNull PsiType parameterType) {
        PsiClass psiClass;
        if (parameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "acceptSimpleType"));
        }
        if (PsiType.CHAR.equals((Object)parameterType) || "java.lang.Character".equals(parameterType.getCanonicalText())) {
            return false;
        }
        if (parameterType instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiPrimitiveType.getUnboxedType((PsiType)parameterType) != null) {
            return true;
        }
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            if (RestParamTypeInspection.hasSingleStringConstructor(psiClass)) {
                return true;
            }
            if (RestParamTypeInspection.hasStaticMethod(psiClass, "valueOf")) {
                return true;
            }
            if (RestParamTypeInspection.hasStaticMethod(psiClass, "fromString")) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasStaticMethod(@NotNull PsiClass psiClass, String methodName) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "hasStaticMethod"));
        }
        PsiMethod valueOf = RestParamTypeInspection.getSingleStringParameterMethod(psiClass.findMethodsByName(methodName, true));
        return valueOf != null && valueOf.getModifierList().hasModifierProperty("static");
    }

    private static boolean hasSingleStringConstructor(PsiClass psiClass) {
        return RestParamTypeInspection.getSingleStringParameterMethod(psiClass.getConstructors()) != null;
    }

    @Nullable
    private static PsiMethod getSingleStringParameterMethod(PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || !"java.lang.String".equals(parameters[0].getType().getCanonicalText())) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("RestParamTypeInspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("RestParamTypeInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/inspections/RestParamTypeInspection", "getShortName"));
        }
        return "RestParamTypeInspection";
    }
}

