/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.library;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.framework.library.LibraryBasedFrameworkType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ws.utils.CommonWsUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class WebServicesFrameworkType
extends LibraryBasedFrameworkType {
    public WebServicesFrameworkType(@NonNls @NotNull String id, Class<? extends DownloadableLibraryType> libraryTypeClass) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ws/rest/library/WebServicesFrameworkType", "<init>"));
        }
        super(id, libraryTypeClass);
    }

    @NotNull
    public FrameworkSupportInModuleProvider createProvider() {
        LibraryBasedFrameworkSupportProvider libraryBasedFrameworkSupportProvider = new LibraryBasedFrameworkSupportProvider((FrameworkTypeEx)this, this.getLibraryTypeClass()){

            @NotNull
            public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ws/rest/library/WebServicesFrameworkType$1", "createConfigurable"));
                }
                MyGenerateConfigurable myGenerateConfigurable = new MyGenerateConfigurable();
                if (myGenerateConfigurable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/library/WebServicesFrameworkType$1", "createConfigurable"));
                }
                return myGenerateConfigurable;
            }
        };
        if (libraryBasedFrameworkSupportProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/library/WebServicesFrameworkType", "createProvider"));
        }
        return libraryBasedFrameworkSupportProvider;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Javaee.WebService;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/rest/library/WebServicesFrameworkType", "getIcon"));
        }
        return icon;
    }

    private class MyGenerateConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private JCheckBox myGenerateClientCode = new JCheckBox("Generate client code sample");
        private JCheckBox myGenerateServerCode = new JCheckBox("Generate server code sample");

        private MyGenerateConfigurable() {
        }

        public JComponent createComponent() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            panel.add((Component)this.myGenerateServerCode, gc);
            panel.add((Component)this.myGenerateClientCode, gc);
            return panel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ws/rest/library/WebServicesFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (rootModel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/ws/rest/library/WebServicesFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            if (modifiableModelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "com/intellij/ws/rest/library/WebServicesFrameworkType$MyGenerateConfigurable", "addSupport"));
            }
            VirtualFile[] sourceRoots = rootModel.getSourceRoots();
            WebFacet webFacet = (WebFacet)modifiableModelsProvider.getFacetModifiableModel(module).findFacet(WebFacet.ID, "Web");
            if (this.myGenerateClientCode.isSelected()) {
                final Project project = module.getProject();
                boolean initialized = project.isInitialized();
                final VirtualFile interfaceFile = CommonWsUtils.addFileToModuleFromTemplate((String[])new String[]{"example", "HelloWorldClient.java"}, (InputStream)new StringBufferInputStream(CommonWsUtils.getDefaultClientCode((Project)project, (String)"example", (String)"HelloWorldClient", (String)"default.webservice.rs.client.java")), (boolean)false, (boolean)true, (VirtualFile[])sourceRoots, (WebFacet)webFacet);
                if (interfaceFile != null) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, interfaceFile), true);
                            if (editor != null) {
                                CommonWsUtils.runTemplate((Editor)editor, (String)"jaxrs");
                            }
                        }
                    };
                    if (initialized) {
                        runnable.run();
                    } else {
                        StartupManager.getInstance((Project)project).registerPostStartupActivity(runnable);
                    }
                }
            }
            if (this.myGenerateServerCode.isSelected() && sourceRoots.length > 0) {
                String text = CommonWsUtils.getFromFileTemplateWithCustomParameters((Project)module.getProject(), (String)"rest.webservice.java", (String[])new String[]{"PACKAGE_NAME", "example", "CLASS_NAME", "HelloWorld"});
                CommonWsUtils.addFileToModuleFromTemplate((String[])new String[]{"example", "HelloWorld.java"}, (InputStream)new StringBufferInputStream(text), (boolean)false, (boolean)true, (VirtualFile[])sourceRoots, (WebFacet)webFacet);
            }
        }

        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(WebServicesFrameworkType.this.getLibraryTypeClass());
        }
    }
}

