/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereNode;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfile;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebSphereCell {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.webSphere.configuration.WebSphereCell");
    public static final WebSphereCell[] EMPTY_ARRAY = new WebSphereCell[0];
    @NonNls
    private static final String ENABLED_SECURITY_ATTRIBUTE = "enabled";
    private final WebSphereProfile myProfile;
    private final File myCellDirectory;
    private final String myCellName;
    private boolean mySecurityEnabled;

    public WebSphereCell(@NotNull WebSphereProfile profile, @NotNull File cellDir, @NotNull String cellName) {
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/j2ee/webSphere/configuration/WebSphereCell", "<init>"));
        }
        if (cellDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellDir", "com/intellij/j2ee/webSphere/configuration/WebSphereCell", "<init>"));
        }
        if (cellName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cellName", "com/intellij/j2ee/webSphere/configuration/WebSphereCell", "<init>"));
        }
        this.myProfile = profile;
        this.myCellDirectory = cellDir;
        this.myCellName = cellName;
        try {
            Document document = JDOMUtil.loadDocument((File)new File(cellDir, "security.xml"));
            String enabled = document.getRootElement().getAttributeValue(ENABLED_SECURITY_ATTRIBUTE);
            this.mySecurityEnabled = Boolean.parseBoolean(enabled);
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public File getCellDirectory() {
        return this.myCellDirectory;
    }

    public WebSphereProfile getProfile() {
        return this.myProfile;
    }

    public String getCellName() {
        return this.myCellName;
    }

    public WebSphereNode[] getNodes() {
        return WebSphereProfileUtil.getNodes(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSphereCell that = (WebSphereCell)o;
        return this.myCellDirectory.equals(that.myCellDirectory) && this.myProfile.equals(that.myProfile);
    }

    public int hashCode() {
        int result = this.myProfile.hashCode();
        result = 29 * result + this.myCellDirectory.hashCode();
        return result;
    }

    public String toString() {
        return this.myCellName;
    }

    public boolean isSecurityEnabled() {
        return this.mySecurityEnabled;
    }
}

