/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.intellij.util.xmlb.annotations.Tag;
import icons.AndroidIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.annotations.NotNull;

class AndroidDataSource
extends LocalDataSource
implements DatabaseSystem,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidDataSource");
    private State myState = new State();

    public AndroidDataSource() {
        super("", "org.sqlite.JDBC", "", null, null);
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "getState"));
        }
        return state;
    }

    @NotNull
    public State buildFullState() {
        this.myState.name = this.getName();
        this.myState.classpathElements = this.serializeClasspathElements();
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "buildFullState"));
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/android/database/AndroidDataSource", "loadState"));
        }
        this.myState = state;
        this.setName(state.name);
        this.setClasspathElements(this.deserializeClasspathElements());
        this.resetUrl();
    }

    @NotNull
    private Element[] serializeClasspathElements() {
        List elements = this.getClasspathElements();
        if (elements.isEmpty()) {
            Element[] elementArray = new Element[]{};
            if (elementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "serializeClasspathElements"));
            }
            return elementArray;
        }
        Element[] serializedElements = new Element[elements.size()];
        int i = 0;
        for (SimpleClasspathElement element : elements) {
            Element serializedElement = new Element("element");
            try {
                element.serialize(serializedElement);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            serializedElements[i++] = serializedElement;
        }
        if (serializedElements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "serializeClasspathElements"));
        }
        return serializedElements;
    }

    @NotNull
    private List<SimpleClasspathElement> deserializeClasspathElements() {
        Element[] serializedElements = this.myState.classpathElements;
        if (serializedElements == null || serializedElements.length == 0) {
            List<SimpleClasspathElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "deserializeClasspathElements"));
            }
            return list;
        }
        ArrayList<SimpleClasspathElement> elements = new ArrayList<SimpleClasspathElement>(serializedElements.length);
        for (Element serializedElement : serializedElements) {
            elements.addAll(SimpleClasspathElementFactory.createElements(null, (Element)serializedElement));
        }
        ArrayList<SimpleClasspathElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "deserializeClasspathElements"));
        }
        return arrayList;
    }

    void resetUrl() {
        this.setUrl(this.buildUrl());
    }

    @NotNull
    public String buildUrl() {
        String path = this.buildLocalDbFileOsPath();
        String string = StringUtil.isEmpty((String)path) ? "" : "jdbc:sqlite:" + FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)path));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "buildUrl"));
        }
        return string;
    }

    @NotNull
    public String buildLocalDbFileOsPath() {
        State state = this.getState();
        String string = AndroidRemoteDataBaseManager.buildLocalDbFileOsPath(state.deviceId, state.packageName, state.databaseName, state.external);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "buildLocalDbFileOsPath"));
        }
        return string;
    }

    public long getModificationCount() {
        return 0L;
    }

    @NotNull
    public AndroidDataSource copy() {
        AndroidDataSource newSource = new AndroidDataSource();
        newSource.setName(this.getName());
        newSource.setDatabaseDriver(this.getDatabaseDriver());
        State newState = newSource.getState();
        State state = this.buildFullState();
        newState.name = state.name;
        newState.deviceId = state.deviceId;
        newState.packageName = state.packageName;
        newState.databaseName = state.databaseName;
        newState.external = state.external;
        newState.classpathElements = AndroidDataSource.cloneElementsArray(state.classpathElements);
        newSource.resetUrl();
        AndroidDataSource androidDataSource = newSource;
        if (androidDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "copy"));
        }
        return androidDataSource;
    }

    @NotNull
    private static Element[] cloneElementsArray(@NotNull Element[] list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/android/database/AndroidDataSource", "cloneElementsArray"));
        }
        Element[] copy = new Element[list.length];
        for (int i = 0; i < list.length; ++i) {
            copy[i] = list[i].clone();
        }
        if (copy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDataSource", "cloneElementsArray"));
        }
        return copy;
    }

    public Icon getBaseIcon() {
        return AndroidIcons.Android;
    }

    public boolean equalConfiguration(@NotNull LocalDataSource o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/android/database/AndroidDataSource", "equalConfiguration"));
        }
        if (!(o instanceof AndroidDataSource)) {
            return super.equalConfiguration(o);
        }
        State s = ((AndroidDataSource)o).getState();
        if (!Comparing.equal((String)this.myState.deviceId, (String)s.deviceId)) {
            return false;
        }
        if (!Comparing.equal((String)this.myState.packageName, (String)s.packageName)) {
            return false;
        }
        if (!Comparing.equal((String)this.myState.databaseName, (String)s.databaseName)) {
            return false;
        }
        if (!Comparing.equal((Object)this.myState.external, (Object)s.external)) {
            return false;
        }
        return Comparing.equal((Object)this.myState.external, (Object)s.external);
    }

    @Tag(value="data-source")
    public static class State {
        public String deviceId = "";
        public String name = "";
        public String packageName = "";
        public String databaseName = "";
        public boolean external = false;
        @Tag(value="classpath-elements")
        public Element[] classpathElements = new Element[0];
    }
}

